/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/adblib/utils/AdbProtocolUtils;", "", "()V", "ADB_CHARSET", "Ljava/nio/charset/Charset;", "getADB_CHARSET", "()Ljava/nio/charset/Charset;", "ADB_NEW_LINE", "", "bufferToByteDumpString", "status", "Ljava/nio/ByteBuffer;", "byteBufferToString", "buffer", "convertFileTimeToEpochSeconds", "", "fileTime", "Ljava/nio/file/attribute/FileTime;", "copyBufferContents", "srcBuffer", "dstBuffer", "createDecoder", "Ljava/nio/charset/CharsetDecoder;", "digitToHexValue", "digit", "encodeLengthPrefix", "length", "is4Letters", "", "letters", "isData", "isDone", "isFail", "isOkay", "android.sdktools.adblib"})
public final class AdbProtocolUtils {
    @NotNull
    public static final AdbProtocolUtils INSTANCE = new AdbProtocolUtils();
    @NotNull
    private static final Charset ADB_CHARSET;
    @NotNull
    public static final String ADB_NEW_LINE = "\n";

    private AdbProtocolUtils() {
    }

    @NotNull
    public final Charset getADB_CHARSET() {
        return ADB_CHARSET;
    }

    public final boolean isOkay(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        return this.is4Letters(buffer2, "OKAY");
    }

    public final boolean isFail(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        return this.is4Letters(buffer2, "FAIL");
    }

    public final boolean isData(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        return this.is4Letters(buffer2, "DATA");
    }

    public final boolean isDone(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        return this.is4Letters(buffer2, "DONE");
    }

    public final int encodeLengthPrefix(int length) {
        if (!(0 <= length ? length < 65536 : false)) {
            throw new IllegalArgumentException("ADB length values are limited to " + new IntRange(0, 65535));
        }
        return (this.digitToHexValue((length & 0xF000) >> 12) << 24) + (this.digitToHexValue((length & 0xF00) >> 8) << 16) + (this.digitToHexValue((length & 0xF0) >> 4) << 8) + this.digitToHexValue(length & 0xF);
    }

    private final int digitToHexValue(int digit) {
        int n = digit;
        return (0 <= n ? n < 10 : false) ? 48 + digit : 65 + digit - 10;
    }

    private final boolean is4Letters(ByteBuffer buffer2, String letters) {
        if (buffer2.remaining() < letters.length()) {
            return false;
        }
        return buffer2.get(0 + buffer2.position()) == (byte)letters.charAt(0) && buffer2.get(1 + buffer2.position()) == (byte)letters.charAt(1) && buffer2.get(2 + buffer2.position()) == (byte)letters.charAt(2) && buffer2.get(3 + buffer2.position()) == (byte)letters.charAt(3);
    }

    @NotNull
    public final String byteBufferToString(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        int position = buffer2.position();
        byte[] bytes = new byte[buffer2.remaining()];
        buffer2.get(bytes);
        buffer2.position(position);
        return new String(bytes, ADB_CHARSET);
    }

    @NotNull
    public final String bufferToByteDumpString(@NotNull ByteBuffer status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int maxCount = 24;
        int position = status.position();
        int n = Math.min(status.remaining(), maxCount);
        for (int i = 0; i < n; ++i) {
            byte statusByte = status.get(i + position);
            String string = "%02x";
            Object[] objectArray = new Object[]{statusByte};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            sb1.append(string2);
            string = "%c";
            objectArray = new Object[]{Character.valueOf((char)statusByte)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            sb2.append(string3);
        }
        String overflow = status.remaining() > maxCount ? " [truncated]" : "";
        return sb1 + " " + sb2 + overflow;
    }

    @NotNull
    public final CharsetDecoder createDecoder() {
        CharsetDecoder charsetDecoder = ADB_CHARSET.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"ADB_CHARSET.newDecoder()");
        return charsetDecoder;
    }

    /*
     * WARNING - void declaration
     */
    public final int copyBufferContents(@NotNull ByteBuffer srcBuffer, @NotNull ByteBuffer dstBuffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)srcBuffer, (String)"srcBuffer");
        Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
        if (dstBuffer.remaining() > srcBuffer.remaining()) {
            int count = srcBuffer.remaining();
            dstBuffer.put(srcBuffer);
            n = count;
        } else {
            void var3_4;
            int count = dstBuffer.remaining();
            if (count > 0) {
                int savedLimit = srcBuffer.limit();
                srcBuffer.limit(srcBuffer.position() + count);
                dstBuffer.put(srcBuffer);
                srcBuffer.limit(savedLimit);
            }
            n = var3_4;
        }
        return n;
    }

    public final int convertFileTimeToEpochSeconds(@NotNull FileTime fileTime) {
        Intrinsics.checkNotNullParameter((Object)fileTime, (String)"fileTime");
        return (int)(fileTime.toMillis() / (long)1000);
    }

    static {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        ADB_CHARSET = charset;
    }
}

