/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.packets;

import com.android.adblib.tools.debugging.packets.AdbBufferedInputChannel;
import com.android.adblib.tools.debugging.packets.JdwpCommands;
import com.android.adblib.tools.debugging.packets.JdwpErrorCode;
import com.android.adblib.tools.debugging.packets.JdwpPacketView;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\b\u0010'\u001a\u00020(H\u0016R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR$\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR$\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\tR\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/android/adblib/tools/debugging/packets/MutableJdwpPacket;", "Lcom/android/adblib/tools/debugging/packets/JdwpPacketView;", "()V", "value", "", "cmd", "getCmd", "()I", "setCmd", "(I)V", "cmdSet", "getCmdSet", "setCmdSet", "errorCode", "getErrorCode", "setErrorCode", "flags", "getFlags", "setFlags", "id", "getId", "setId", "", "isCommand", "()Z", "setCommand", "(Z)V", "isReply", "setReply", "length", "getLength", "setLength", "payload", "Lcom/android/adblib/tools/debugging/packets/AdbBufferedInputChannel;", "getPayload", "()Lcom/android/adblib/tools/debugging/packets/AdbBufferedInputChannel;", "setPayload", "(Lcom/android/adblib/tools/debugging/packets/AdbBufferedInputChannel;)V", "", "toString", "", "Companion", "android.sdktools.adblib.tools"})
public final class MutableJdwpPacket
implements JdwpPacketView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int length;
    private int id;
    private int flags;
    private int cmdSet;
    private int cmd;
    private int errorCode;
    @NotNull
    private AdbBufferedInputChannel payload = AdbBufferedInputChannel.Companion.empty();

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int value) {
        if (value < 11) {
            throw new IllegalArgumentException("Packet length should always be greater or equal to 11");
        }
        this.length = value;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Flags value should be with the [0..255] range");
        }
        this.flags = value & 0xFF;
    }

    @Override
    public boolean isReply() {
        return (this.getFlags() & 0x80) != 0;
    }

    public void setReply(boolean value) {
        this.setFlags(value ? this.getFlags() | 0x80 : this.getFlags() & 0xFFFFFF7F);
    }

    @Override
    public boolean isCommand() {
        return !this.isReply();
    }

    public void setCommand(boolean value) {
        this.setReply(!value);
    }

    @Override
    public int getCmdSet() {
        if (this.isReply()) {
            throw new IllegalStateException("CmdSet is not available because JDWP packet is a reply packet");
        }
        return this.cmdSet;
    }

    public void setCmdSet(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("CmdSet value " + value + " should be with the [0..255] range");
        }
        this.cmdSet = value & 0xFF;
    }

    @Override
    public int getCmd() {
        if (this.isReply()) {
            throw new IllegalStateException("Cmd is not available because JDWP packet is a reply packet");
        }
        return this.cmd;
    }

    public void setCmd(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Cmd value should be with the [0..255] range");
        }
        this.cmd = value & 0xFF;
    }

    @Override
    public int getErrorCode() {
        if (this.isCommand()) {
            throw new IllegalStateException("ErrorCode is not available because JDWP packet is a command packet");
        }
        return this.errorCode;
    }

    public void setErrorCode(int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Cmd value should be with the [0..65535] range");
        }
        this.errorCode = value & 0xFFFF;
    }

    @Override
    @NotNull
    public AdbBufferedInputChannel getPayload() {
        return this.payload;
    }

    public void setPayload(@NotNull AdbBufferedInputChannel adbBufferedInputChannel) {
        Intrinsics.checkNotNullParameter((Object)adbBufferedInputChannel, (String)"<set-?>");
        this.payload = adbBufferedInputChannel;
    }

    @NotNull
    public String toString() {
        String string;
        String string2 = "JdwpPacket(id=%d, length=%d, flags=0x%02X, %s)";
        Object[] objectArray = new Object[4];
        objectArray[0] = this.getId();
        objectArray[1] = this.getLength();
        objectArray[2] = this.getFlags();
        if (this.isReply()) {
            String string3 = "isReply=true, errorCode=%s[%d]";
            Object[] objectArray2 = new Object[]{JdwpErrorCode.Companion.errorName(this.getErrorCode()), this.getErrorCode()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
        } else {
            String string5 = "isCommand=true, cmdSet=%s[%d], cmd=%s[%d]";
            Object[] objectArray3 = new Object[]{JdwpCommands.INSTANCE.cmdSetToString(this.getCmdSet()), this.getCmdSet(), JdwpCommands.INSTANCE.cmdToString(this.getCmdSet(), this.getCmd()), this.getCmd()};
            String string6 = String.format(string5, Arrays.copyOf(objectArray3, objectArray3.length));
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
        }
        objectArray[3] = string;
        String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(this, *args)");
        return string7;
    }

    public final void setCommand(int cmdSet, int cmd) {
        this.setCommand(true);
        this.setCmdSet(cmdSet);
        this.setCmd(cmd);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/tools/debugging/packets/MutableJdwpPacket$Companion;", "", "()V", "createCommandPacket", "Lcom/android/adblib/tools/debugging/packets/MutableJdwpPacket;", "packetId", "", "cmdSet", "cmd", "payload", "Ljava/nio/ByteBuffer;", "android.sdktools.adblib.tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableJdwpPacket createCommandPacket(int packetId, int cmdSet, int cmd, @NotNull ByteBuffer payload) {
            MutableJdwpPacket mutableJdwpPacket;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            MutableJdwpPacket $this$createCommandPacket_u24lambda_u240 = mutableJdwpPacket = new MutableJdwpPacket();
            boolean bl = false;
            $this$createCommandPacket_u24lambda_u240.setId(packetId);
            $this$createCommandPacket_u24lambda_u240.setLength(11 + payload.remaining());
            $this$createCommandPacket_u24lambda_u240.setCommand(cmdSet, cmd);
            $this$createCommandPacket_u24lambda_u240.setPayload(AdbBufferedInputChannel.Companion.forByteBuffer(payload));
            return mutableJdwpPacket;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

