/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbChannel;
import com.android.adblib.AdbInputChannel;
import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbLoggerKt;
import com.android.adblib.AdbOutputChannel;
import com.android.adblib.AdbProtocolErrorException;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.DeviceSelector;
import com.android.adblib.SyncProgress;
import com.android.adblib.impl.SyncRecvHandler;
import com.android.adblib.impl.TimeoutTracker;
import com.android.adblib.impl.services.AdbServiceRunner;
import com.android.adblib.utils.AdbProtocolUtils;
import com.android.adblib.utils.ResizableBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ3\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/android/adblib/impl/SyncRecvHandler;", "", "serviceRunner", "Lcom/android/adblib/impl/services/AdbServiceRunner;", "device", "Lcom/android/adblib/DeviceSelector;", "deviceChannel", "Lcom/android/adblib/AdbChannel;", "(Lcom/android/adblib/impl/services/AdbServiceRunner;Lcom/android/adblib/DeviceSelector;Lcom/android/adblib/AdbChannel;)V", "host", "Lcom/android/adblib/AdbSessionHost;", "getHost", "()Lcom/android/adblib/AdbSessionHost;", "logger", "Lcom/android/adblib/AdbLogger;", "workBuffer", "Lcom/android/adblib/utils/ResizableBuffer;", "commitDestinationChannel", "", "remoteFilePath", "", "destinationChannel", "Lcom/android/adblib/AdbOutputChannel;", "byteCount", "", "progress", "Lcom/android/adblib/SyncProgress;", "(Ljava/lang/String;Lcom/android/adblib/AdbOutputChannel;JLcom/android/adblib/SyncProgress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "receiveFileContents", "(Ljava/lang/String;Lcom/android/adblib/AdbOutputChannel;Lcom/android/adblib/SyncProgress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recv", "startRecvRequest", "(Ljava/lang/String;Lcom/android/adblib/SyncProgress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nSyncRecvHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncRecvHandler.kt\ncom/android/adblib/impl/SyncRecvHandler\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,193:1\n122#2:194\n115#2:195\n41#3:196\n21#3,4:197\n42#3:201\n*S KotlinDebug\n*F\n+ 1 SyncRecvHandler.kt\ncom/android/adblib/impl/SyncRecvHandler\n*L\n42#1:194\n42#1:195\n97#1:196\n97#1:197,4\n97#1:201\n*E\n"})
public final class SyncRecvHandler {
    @NotNull
    private final AdbServiceRunner serviceRunner;
    @NotNull
    private final DeviceSelector device;
    @NotNull
    private final AdbChannel deviceChannel;
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private final ResizableBuffer workBuffer;

    /*
     * WARNING - void declaration
     */
    public SyncRecvHandler(@NotNull AdbServiceRunner serviceRunner, @NotNull DeviceSelector device2, @NotNull AdbChannel deviceChannel) {
        void $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)serviceRunner, (String)"serviceRunner");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)deviceChannel, (String)"deviceChannel");
        this.serviceRunner = serviceRunner;
        this.device = device2;
        this.deviceChannel = deviceChannel;
        SyncRecvHandler syncRecvHandler = this;
        AdbSessionHost host$iv = this.getHost();
        boolean $i$f$thisLogger = false;
        void var7_7 = $this$thisLogger$iv;
        AdbLoggerFactory loggerFactory$iv$iv = host$iv.getLoggerFactory();
        boolean $i$f$thisLogger2 = false;
        this.logger = AdbLoggerKt.withPrefix(loggerFactory$iv$iv.createLogger(SyncRecvHandler.class), "device:" + this.device + ",sync:RECV - ");
        ResizableBuffer resizableBuffer = AdbServiceRunner.newResizableBuffer$default(this.serviceRunner, 0, 1, null);
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        this.workBuffer = resizableBuffer.order(byteOrder);
    }

    private final AdbSessionHost getHost() {
        return this.serviceRunner.getHost();
    }

    @Nullable
    public final Object recv(@NotNull String remoteFilePath, @NotNull AdbOutputChannel destinationChannel, @Nullable SyncProgress progress2, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.getHost().getIoDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, remoteFilePath, progress2, destinationChannel, null){
            int label;
            final /* synthetic */ SyncRecvHandler this$0;
            final /* synthetic */ String $remoteFilePath;
            final /* synthetic */ SyncProgress $progress;
            final /* synthetic */ AdbOutputChannel $destinationChannel;
            {
                this.this$0 = $receiver;
                this.$remoteFilePath = $remoteFilePath;
                this.$progress = $progress;
                this.$destinationChannel = $destinationChannel;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = SyncRecvHandler.access$getLogger$p(this.this$0);
                        var3_5 = this.$remoteFilePath;
                        var4_6 = this.$destinationChannel;
                        $i$f$info = false;
                        var6_8 = this_$iv;
                        level$iv$iv = AdbLogger.Level.INFO;
                        $i$f$logIf = false;
                        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                            var11_11 = level$iv$iv;
                            var10_12 = this_$iv$iv;
                            $i$a$-info-SyncRecvHandler$recv$2$1 = false;
                            var12_14 = "\"" + var3_5 + "\" -> " + var4_6;
                            var10_12.log(var11_11, var12_14);
                        }
                        if (this.$remoteFilePath.length() > 1024) {
                            SyncRecvHandler.access$getLogger$p(this.this$0).warn("\"" + this.$remoteFilePath + "\": Remote path length is too long (1024)");
                            throw new IllegalArgumentException("Remote paths are limited to 1024 characters");
                        }
                        this.label = 1;
                        v0 = SyncRecvHandler.access$startRecvRequest(this.this$0, this.$remoteFilePath, this.$progress, (Continuation)this);
                        if (v0 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl31
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 2 sources

                        this.label = 2;
                        v1 = SyncRecvHandler.access$receiveFileContents(this.this$0, this.$remoteFilePath, this.$destinationChannel, this.$progress, (Continuation)this);
                        if (v1 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl39
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl39:
                        // 2 sources

                        byteCount = ((Number)v1).longValue();
                        this.label = 3;
                        v2 = SyncRecvHandler.access$commitDestinationChannel(this.this$0, this.$remoteFilePath, this.$destinationChannel, byteCount, this.$progress, (Continuation)this);
                        if (v2 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl48
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl48:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object startRecvRequest(String var1_1, SyncProgress var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof startRecvRequest.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SyncRecvHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SyncRecvHandler.access$startRecvRequest(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = progress;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.L$1 = remoteFilePath;
                $continuation.label = 1;
                v1 = v0.transferStarted(remoteFilePath, (Continuation<? super Unit>)$continuation);
                if (v1 == var15_6) {
                    return var15_6;
                }
                break;
            }
            case 1: {
                remoteFilePath = (String)$continuation.L$1;
                this = (SyncRecvHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        this_$iv = this.logger;
        $i$f$debug = false;
        var6_10 = this_$iv;
        level$iv$iv = AdbLogger.Level.DEBUG;
        $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            var11_13 = level$iv$iv;
            var10_14 = this_$iv$iv;
            $i$a$-debug-SyncRecvHandler$startRecvRequest$2 = false;
            var12_16 = "sending \"RECV\" command to device " + this.device;
            var10_14.log(var11_13, var12_16);
        }
        this.workBuffer.clear();
        this.workBuffer.appendString("RECV", AdbProtocolUtils.INSTANCE.getADB_CHARSET());
        lengthPos = this.workBuffer.getPosition();
        this.workBuffer.appendInt(0);
        this.workBuffer.appendString(remoteFilePath, AdbProtocolUtils.INSTANCE.getADB_CHARSET());
        this.workBuffer.setInt(lengthPos, this.workBuffer.getPosition() - 8);
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.label = 2;
        v2 = AdbOutputChannel.writeExactly$default(this.deviceChannel, this.workBuffer.forChannelWrite(), 0L, null, (Continuation)$continuation, 6, null);
        if (v2 == var15_6) {
            return var15_6;
        }
        ** GOTO lbl56
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl56:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object receiveFileContents(String var1_1, AdbOutputChannel var2_2, SyncProgress var3_3, Continuation<? super Long> var4_4) {
        block15: {
            block17: {
                block16: {
                    if (!(var4_4 instanceof receiveFileContents.1)) ** GOTO lbl-1000
                    var11_5 = var4_4;
                    if ((var11_5.label & -2147483648) != 0) {
                        var11_5.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var4_4){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            long J$0;
                            int I$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ SyncRecvHandler this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return SyncRecvHandler.access$receiveFileContents(this.this$0, null, null, null, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            totalBytesSoFar = 0L;
lbl14:
                            // 5 sources

                            while (true) {
                                this.workBuffer.clear();
                                $continuation.L$0 = this;
                                $continuation.L$1 = remoteFilePath;
                                $continuation.L$2 = destinationChannel;
                                $continuation.L$3 = progress;
                                $continuation.J$0 = totalBytesSoFar;
                                $continuation.label = 1;
                                v0 = AdbInputChannel.readExactly$default(this.deviceChannel, this.workBuffer.forChannelRead(8), 0L, null, (Continuation)$continuation, 6, null);
                                if (v0 == var12_7) {
                                    return var12_7;
                                }
                                ** GOTO lbl34
                                break;
                            }
                        }
                        case 1: {
                            totalBytesSoFar = $continuation.J$0;
                            progress = (SyncProgress)$continuation.L$3;
                            destinationChannel = (AdbOutputChannel)$continuation.L$2;
                            remoteFilePath = (String)$continuation.L$1;
                            this = (SyncRecvHandler)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl34:
                            // 2 sources

                            buffer = ResizableBuffer.afterChannelRead$default(this.workBuffer, 0, 1, null);
                            if (AdbProtocolUtils.INSTANCE.isDone(buffer)) break block15;
                            if (!AdbProtocolUtils.INSTANCE.isData(buffer)) break block16;
                            buffer.getInt();
                            chunkLength = buffer.getInt();
                            this.workBuffer.clear();
                            $continuation.L$0 = this;
                            $continuation.L$1 = remoteFilePath;
                            $continuation.L$2 = destinationChannel;
                            $continuation.L$3 = progress;
                            $continuation.J$0 = totalBytesSoFar;
                            $continuation.I$0 = chunkLength;
                            $continuation.label = 2;
                            v1 = AdbInputChannel.readExactly$default(this.deviceChannel, this.workBuffer.forChannelRead(chunkLength), 0L, null, (Continuation)$continuation, 6, null);
                            if (v1 == var12_7) {
                                return var12_7;
                            }
                            ** GOTO lbl62
                        }
                        case 2: {
                            chunkLength = $continuation.I$0;
                            totalBytesSoFar = $continuation.J$0;
                            progress = (SyncProgress)$continuation.L$3;
                            destinationChannel = (AdbOutputChannel)$continuation.L$2;
                            remoteFilePath = (String)$continuation.L$1;
                            this = (SyncRecvHandler)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl62:
                            // 2 sources

                            $continuation.L$0 = this;
                            $continuation.L$1 = remoteFilePath;
                            $continuation.L$2 = destinationChannel;
                            $continuation.L$3 = progress;
                            $continuation.J$0 = totalBytesSoFar;
                            $continuation.I$0 = chunkLength;
                            $continuation.label = 3;
                            v2 = AdbOutputChannel.writeExactly$default(destinationChannel, ResizableBuffer.afterChannelRead$default(this.workBuffer, 0, 1, null), 0L, null, (Continuation)$continuation, 6, null);
                            if (v2 == var12_7) {
                                return var12_7;
                            }
                            ** GOTO lbl82
                        }
                        case 3: {
                            chunkLength = $continuation.I$0;
                            totalBytesSoFar = $continuation.J$0;
                            progress = (SyncProgress)$continuation.L$3;
                            destinationChannel = (AdbOutputChannel)$continuation.L$2;
                            remoteFilePath = (String)$continuation.L$1;
                            this = (SyncRecvHandler)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl82:
                            // 2 sources

                            totalBytesSoFar += (long)chunkLength;
                            v3 = progress;
                            if (v3 == null) break;
                            $continuation.L$0 = this;
                            $continuation.L$1 = remoteFilePath;
                            $continuation.L$2 = destinationChannel;
                            $continuation.L$3 = progress;
                            $continuation.J$0 = totalBytesSoFar;
                            $continuation.label = 4;
                            v4 = v3.transferProgress(remoteFilePath, totalBytesSoFar, (Continuation<? super Unit>)$continuation);
                            if (v4 != var12_7) ** GOTO lbl14
                            return var12_7;
                        }
                        case 4: {
                            totalBytesSoFar = $continuation.J$0;
                            progress = (SyncProgress)$continuation.L$3;
                            destinationChannel = (AdbOutputChannel)$continuation.L$2;
                            remoteFilePath = (String)$continuation.L$1;
                            this = (SyncRecvHandler)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
                            ** GOTO lbl14
                        }
                    }
                    ** GOTO lbl14
                }
                if (!AdbProtocolUtils.INSTANCE.isFail(buffer)) break block17;
                buffer.getInt();
                length = buffer.getInt();
                $continuation.L$0 = this;
                $continuation.L$1 = remoteFilePath;
                $continuation.L$2 = destinationChannel;
                $continuation.L$3 = progress;
                $continuation.J$0 = totalBytesSoFar;
                $continuation.label = 5;
                v5 = this.serviceRunner.readSyncFailMessageAndThrow(this.device, "sync-recv('" + remoteFilePath + "')", this.deviceChannel, this.workBuffer, length, TimeoutTracker.Companion.getINFINITE(), (Continuation<? super Unit>)$continuation);
                if (v5 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl127
                {
                    case 5: {
                        totalBytesSoFar = $continuation.J$0;
                        progress = (SyncProgress)$continuation.L$3;
                        destinationChannel = (AdbOutputChannel)$continuation.L$2;
                        remoteFilePath = (String)$continuation.L$1;
                        this = (SyncRecvHandler)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl127:
                        // 2 sources

                        ** continue;
                    }
                }
            }
            contents = AdbProtocolUtils.INSTANCE.bufferToByteDumpString(buffer);
            errorMessage = "Received an invalid packet from a RECV sync query: " + contents;
            throw new AdbProtocolErrorException(errorMessage);
        }
        return Boxing.boxLong((long)totalBytesSoFar);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object commitDestinationChannel(String remoteFilePath, AdbOutputChannel destinationChannel, long byteCount, SyncProgress progress2, Continuation<? super Unit> $completion) {
        destinationChannel.close();
        SyncProgress syncProgress = progress2;
        if (syncProgress != null) {
            Object object = syncProgress.transferDone(remoteFilePath, byteCount, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AdbLogger access$getLogger$p(SyncRecvHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$startRecvRequest(SyncRecvHandler $this, String remoteFilePath, SyncProgress progress2, Continuation $completion) {
        return $this.startRecvRequest(remoteFilePath, progress2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$receiveFileContents(SyncRecvHandler $this, String remoteFilePath, AdbOutputChannel destinationChannel, SyncProgress progress2, Continuation $completion) {
        return $this.receiveFileContents(remoteFilePath, destinationChannel, progress2, (Continuation<? super Long>)$completion);
    }

    public static final /* synthetic */ Object access$commitDestinationChannel(SyncRecvHandler $this, String remoteFilePath, AdbOutputChannel destinationChannel, long byteCount, SyncProgress progress2, Continuation $completion) {
        return $this.commitDestinationChannel(remoteFilePath, destinationChannel, byteCount, progress2, (Continuation<? super Unit>)$completion);
    }
}

