/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbOutputChannel;
import com.android.adblib.impl.ShellV2PacketKind;
import com.android.adblib.impl.TimeoutTracker;
import com.android.adblib.utils.ResizableBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/android/adblib/impl/ShellV2ProtocolWriter;", "", "deviceChannel", "Lcom/android/adblib/AdbOutputChannel;", "workBuffer", "Lcom/android/adblib/utils/ResizableBuffer;", "(Lcom/android/adblib/AdbOutputChannel;Lcom/android/adblib/utils/ResizableBuffer;)V", "prepareWriteBuffer", "Ljava/nio/ByteBuffer;", "bufferSize", "", "writePreparedBuffer", "", "kind", "Lcom/android/adblib/impl/ShellV2PacketKind;", "timeout", "Lcom/android/adblib/impl/TimeoutTracker;", "(Lcom/android/adblib/impl/ShellV2PacketKind;Lcom/android/adblib/impl/TimeoutTracker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "android.sdktools.adblib"})
public final class ShellV2ProtocolWriter {
    @NotNull
    private final AdbOutputChannel deviceChannel;
    @NotNull
    private final ResizableBuffer workBuffer;

    public ShellV2ProtocolWriter(@NotNull AdbOutputChannel deviceChannel, @NotNull ResizableBuffer workBuffer) {
        Intrinsics.checkNotNullParameter((Object)deviceChannel, (String)"deviceChannel");
        Intrinsics.checkNotNullParameter((Object)workBuffer, (String)"workBuffer");
        this.deviceChannel = deviceChannel;
        this.workBuffer = workBuffer;
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        this.workBuffer.order(byteOrder);
    }

    @NotNull
    public final ByteBuffer prepareWriteBuffer(int bufferSize) {
        boolean bl;
        this.workBuffer.clear();
        this.workBuffer.appendByte((byte)0);
        this.workBuffer.appendInt(0);
        boolean bl2 = bl = this.workBuffer.getPosition() == 5;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.workBuffer.forChannelRead(bufferSize - 5);
    }

    @Nullable
    public final Object writePreparedBuffer(@NotNull ShellV2PacketKind kind, @NotNull TimeoutTracker timeout, @NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        ByteBuffer buffer2 = this.workBuffer.afterChannelRead(0);
        int packetLength = buffer2.remaining() - 5;
        boolean bl2 = bl = packetLength >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        buffer2.put(0, (byte)kind.getValue());
        buffer2.putInt(1, packetLength);
        Object object = this.deviceChannel.writeExactly(buffer2, timeout.getRemainingNanos(), TimeUnit.NANOSECONDS, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object writePreparedBuffer$default(ShellV2ProtocolWriter shellV2ProtocolWriter, ShellV2PacketKind shellV2PacketKind, TimeoutTracker timeoutTracker, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            timeoutTracker = TimeoutTracker.Companion.getINFINITE();
        }
        return shellV2ProtocolWriter.writePreparedBuffer(shellV2PacketKind, timeoutTracker, (Continuation<? super Unit>)continuation);
    }
}

