/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.DeviceAddress;
import com.android.adblib.ErrorLine;
import com.android.adblib.ListWithErrors;
import com.android.adblib.MdnsServiceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/impl/MdnsServiceListParser;", "", "()V", "lineRegex", "Lkotlin/text/Regex;", "parse", "Lcom/android/adblib/ListWithErrors;", "Lcom/android/adblib/MdnsServiceInfo;", "Lcom/android/adblib/MdnsServiceList;", "text", "", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nMdnsServiceListParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnsServiceListParser.kt\ncom/android/adblib/impl/MdnsServiceListParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n766#2:87\n857#2,2:88\n1860#2,3:90\n*S KotlinDebug\n*F\n+ 1 MdnsServiceListParser.kt\ncom/android/adblib/impl/MdnsServiceListParser\n*L\n56#1:87\n56#1:88,2\n57#1:90,3\n*E\n"})
public final class MdnsServiceListParser {
    @NotNull
    private final Regex lineRegex = new Regex("([^\t]+)\\t([^\t]+)\\t([^\t]+)");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ListWithErrors<MdnsServiceInfo> parse(@NotNull CharSequence text) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ListWithErrors.Builder<MdnsServiceInfo> builder = new ListWithErrors.Builder<MdnsServiceInfo>();
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEachIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (String)item$iv;
            int lineIndex = n;
            boolean bl = false;
            MatchResult matchResult = Regex.find$default((Regex)this.lineRegex, (CharSequence)((CharSequence)line), (int)0, (int)2, null);
            if (matchResult == null) {
                ErrorLine error = new ErrorLine("mDNS service entry format not recognized", lineIndex, (String)line);
                builder.addError(error);
                continue;
            }
            try {
                String instanceName = (String)matchResult.getGroupValues().get(1);
                String serviceName = (String)matchResult.getGroupValues().get(2);
                DeviceAddress deviceAddress = new DeviceAddress((String)matchResult.getGroupValues().get(3));
                builder.addEntry(new MdnsServiceInfo(instanceName, serviceName, deviceAddress));
            }
            catch (Exception ignored) {
                ErrorLine error = new ErrorLine("mDNS service entry ignored due do invalid characters", lineIndex, (String)line);
                builder.addError(error);
            }
        }
        return builder.build();
    }
}

