/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbChannelFactory;
import com.android.adblib.AdbChannelProvider;
import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbHostServices;
import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.ClosedSessionException;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.impl.AdbDeviceServicesImpl;
import com.android.adblib.impl.AdbHostServicesImpl;
import com.android.adblib.impl.CoroutineScopeCacheImpl;
import com.android.adblib.impl.channels.AdbChannelFactoryImpl;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0018H\u0002J\b\u0010*\u001a\u00020\u001eH\u0002J\b\u0010+\u001a\u00020(H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Lcom/android/adblib/impl/AdbSessionImpl;", "Lcom/android/adblib/AdbSession;", "host", "Lcom/android/adblib/AdbSessionHost;", "channelProvider", "Lcom/android/adblib/AdbChannelProvider;", "connectionTimeoutMillis", "", "(Lcom/android/adblib/AdbSessionHost;Lcom/android/adblib/AdbChannelProvider;J)V", "_cache", "Lcom/android/adblib/impl/CoroutineScopeCacheImpl;", "cache", "Lcom/android/adblib/CoroutineScopeCache;", "getCache", "()Lcom/android/adblib/CoroutineScopeCache;", "channelFactory", "Lcom/android/adblib/AdbChannelFactory;", "getChannelFactory", "()Lcom/android/adblib/AdbChannelFactory;", "getChannelProvider", "()Lcom/android/adblib/AdbChannelProvider;", "closed", "", "deviceServices", "Lcom/android/adblib/AdbDeviceServices;", "getDeviceServices", "()Lcom/android/adblib/AdbDeviceServices;", "getHost", "()Lcom/android/adblib/AdbSessionHost;", "hostServices", "Lcom/android/adblib/AdbHostServices;", "getHostServices", "()Lcom/android/adblib/AdbHostServices;", "logger", "Lcom/android/adblib/AdbLogger;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "close", "", "createDeviceServices", "createHostServices", "throwIfClosed", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nAdbSessionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbSessionImpl.kt\ncom/android/adblib/impl/AdbSessionImpl\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,110:1\n122#2:111\n115#2:112\n41#3:113\n21#3,4:114\n42#3:118\n*S KotlinDebug\n*F\n+ 1 AdbSessionImpl.kt\ncom/android/adblib/impl/AdbSessionImpl\n*L\n40#1:111\n40#1:112\n86#1:113\n86#1:114,4\n86#1:118\n*E\n"})
public final class AdbSessionImpl
implements AdbSession {
    @NotNull
    private final AdbSessionHost host;
    @NotNull
    private final AdbChannelProvider channelProvider;
    private final long connectionTimeoutMillis;
    @NotNull
    private final AdbLogger logger;
    private boolean closed;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AdbChannelFactory channelFactory;
    @NotNull
    private final AdbHostServices hostServices;
    @NotNull
    private final AdbDeviceServices deviceServices;
    @NotNull
    private final CoroutineScopeCacheImpl _cache;

    /*
     * WARNING - void declaration
     */
    public AdbSessionImpl(@NotNull AdbSessionHost host, @NotNull AdbChannelProvider channelProvider2, long connectionTimeoutMillis) {
        void $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)channelProvider2, (String)"channelProvider");
        this.host = host;
        this.channelProvider = channelProvider2;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        AdbSessionImpl adbSessionImpl = this;
        AdbSessionHost host$iv = this.getHost();
        boolean $i$f$thisLogger = false;
        void var8_7 = $this$thisLogger$iv;
        AdbLoggerFactory loggerFactory$iv$iv = host$iv.getLoggerFactory();
        boolean $i$f$thisLogger2 = false;
        this.logger = loggerFactory$iv$iv.createLogger(AdbSessionImpl.class);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.getHost().getParentContext().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)this.getHost().getIoDispatcher()));
        this.channelFactory = new AdbChannelFactoryImpl(this);
        this.hostServices = this.createHostServices();
        this.deviceServices = this.createDeviceServices();
        this._cache = new CoroutineScopeCacheImpl(this.getScope());
    }

    @Override
    @NotNull
    public AdbSessionHost getHost() {
        return this.host;
    }

    @NotNull
    public final AdbChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    @Override
    @NotNull
    public CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public AdbChannelFactory getChannelFactory() {
        this.throwIfClosed();
        return this.channelFactory;
    }

    @Override
    @NotNull
    public AdbHostServices getHostServices() {
        this.throwIfClosed();
        return this.hostServices;
    }

    @Override
    @NotNull
    public AdbDeviceServices getDeviceServices() {
        this.throwIfClosed();
        return this.deviceServices;
    }

    @Override
    @NotNull
    public CoroutineScopeCache getCache() {
        this.throwIfClosed();
        return this._cache;
    }

    @Override
    public void throwIfClosed() {
        if (this.closed) {
            throw new ClosedSessionException("Session has been closed");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (!this.closed) {
            void this_$iv$iv;
            this.closed = true;
            AdbLogger this_$iv = this.logger;
            boolean $i$f$debug = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var7_7 = this_$iv$iv;
                boolean bl = false;
                String string = "Closing session and cancelling session scope";
                var7_7.log(level, string);
            }
            this._cache.close();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.getScope(), (String)"adblib session has been cancelled", null, (int)2, null);
        }
    }

    private final AdbHostServices createHostServices() {
        return new AdbHostServicesImpl(this, this.channelProvider, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private final AdbDeviceServices createDeviceServices() {
        return new AdbDeviceServicesImpl(this, this.channelProvider, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }
}

