/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.SystemNanoTimeProvider;
import com.android.adblib.utils.JdkLoggerFactory;
import com.android.adblib.utils.SystemNanoTime;
import java.nio.channels.AsynchronousChannelGroup;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0006/01234B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010#\u001a\u00020$H\u0016J%\u0010%\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0\u001aH\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020+H\u0014J\b\u0010-\u001a\u00020.H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lcom/android/adblib/AdbSessionHost;", "Ljava/lang/AutoCloseable;", "()V", "asynchronousChannelGroup", "Ljava/nio/channels/AsynchronousChannelGroup;", "getAsynchronousChannelGroup", "()Ljava/nio/channels/AsynchronousChannelGroup;", "blockingIoDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getBlockingIoDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "ioDispatcher", "getIoDispatcher", "isEventDispatchThread", "", "()Z", "logger", "Lcom/android/adblib/AdbLogger;", "getLogger", "()Lcom/android/adblib/AdbLogger;", "loggerFactory", "Lcom/android/adblib/AdbLoggerFactory;", "getLoggerFactory", "()Lcom/android/adblib/AdbLoggerFactory;", "loggingFilter", "Lcom/android/adblib/AdbSessionHost$OnlyOnceFilter;", "Lcom/android/adblib/AdbSessionHost$Property;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "getParentContext", "()Lkotlin/coroutines/CoroutineContext;", "timeProvider", "Lcom/android/adblib/SystemNanoTimeProvider;", "getTimeProvider", "()Lcom/android/adblib/SystemNanoTimeProvider;", "close", "", "getPropertyValue", "T", "", "property", "(Lcom/android/adblib/AdbSessionHost$Property;)Ljava/lang/Object;", "getSystemProperty", "", "name", "utcNow", "Ljava/time/Instant;", "BooleanProperty", "DurationProperty", "IntProperty", "OnlyOnceFilter", "Property", "StringProperty", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nAdbSessionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbSessionHost.kt\ncom/android/adblib/AdbSessionHost\n+ 2 AdbSessionHost.kt\ncom/android/adblib/AdbSessionHost$OnlyOnceFilter\n*L\n1#1,244:1\n238#2,4:245\n*S KotlinDebug\n*F\n+ 1 AdbSessionHost.kt\ncom/android/adblib/AdbSessionHost\n*L\n118#1:245,4\n*E\n"})
public class AdbSessionHost
implements AutoCloseable {
    @NotNull
    private final OnlyOnceFilter<Property<?>> loggingFilter = new OnlyOnceFilter();
    @NotNull
    private final SystemNanoTimeProvider timeProvider = new SystemNanoTime();
    @NotNull
    private final AdbLoggerFactory loggerFactory = new JdkLoggerFactory();
    @Nullable
    private final AsynchronousChannelGroup asynchronousChannelGroup;
    @NotNull
    private final CoroutineContext parentContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;

    @NotNull
    public SystemNanoTimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @NotNull
    public AdbLoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @NotNull
    public final AdbLogger getLogger() {
        return this.getLoggerFactory().getLogger();
    }

    @Nullable
    public AsynchronousChannelGroup getAsynchronousChannelGroup() {
        return this.asynchronousChannelGroup;
    }

    @NotNull
    public CoroutineContext getParentContext() {
        return this.parentContext;
    }

    @NotNull
    public CoroutineDispatcher getIoDispatcher() {
        return Dispatchers.getDefault();
    }

    @NotNull
    public CoroutineDispatcher getBlockingIoDispatcher() {
        return Dispatchers.getIO();
    }

    public boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @NotNull
    public Instant utcNow() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return instant;
    }

    @NotNull
    public <T> T getPropertyValue(@NotNull Property<T> property) {
        T t;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        String string = this.getSystemProperty(property.getName());
        if (string == null) {
            return property.getDefaultValue();
        }
        String propertyValue = string;
        try {
            t = property.fromStringValue(propertyValue);
        }
        catch (Throwable t2) {
            OnlyOnceFilter<Property<?>> this_$iv = this.loggingFilter;
            boolean $i$f$filter = false;
            if (((OnlyOnceFilter)this_$iv).seenKeys.add(property)) {
                boolean bl = false;
                this.getLogger().warn(t2, "Invalid or unsupported value '" + propertyValue + "' for property '" + property.getName() + "', using default value '" + property.getDefaultValue() + "' instead");
            }
            t = property.getDefaultValue();
        }
        return t;
    }

    @Override
    public void close() throws Exception {
    }

    @Nullable
    protected String getSystemProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return System.getProperty(name);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/AdbSessionHost$BooleanProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "", "name", "", "defaultValue", "isVolatile", "(Ljava/lang/String;ZZ)V", "fromStringValue", "value", "(Ljava/lang/String;)Ljava/lang/Boolean;", "android.sdktools.adblib"})
    public static final class BooleanProperty
    extends Property<Boolean> {
        public BooleanProperty(@NotNull String name, boolean defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ BooleanProperty(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string, bl, bl2);
        }

        @Override
        @NotNull
        public Boolean fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Boolean.parseBoolean(value);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/AdbSessionHost$DurationProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "Ljava/time/Duration;", "name", "", "defaultValue", "isVolatile", "", "(Ljava/lang/String;Ljava/time/Duration;Z)V", "fromStringValue", "value", "android.sdktools.adblib"})
    public static final class DurationProperty
    extends Property<Duration> {
        public DurationProperty(@NotNull String name, @NotNull Duration defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ DurationProperty(String string, Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, duration, bl);
        }

        @Override
        @NotNull
        public Duration fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Duration duration = Duration.parse(value);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(value)");
            return duration;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/adblib/AdbSessionHost$IntProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "", "name", "", "defaultValue", "isVolatile", "", "(Ljava/lang/String;IZ)V", "fromStringValue", "value", "(Ljava/lang/String;)Ljava/lang/Integer;", "android.sdktools.adblib"})
    public static final class IntProperty
    extends Property<Integer> {
        public IntProperty(@NotNull String name, int defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ IntProperty(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(string, n, bl);
        }

        @Override
        @NotNull
        public Integer fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Integer.parseInt(value);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J'\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rRN\u0010\u0004\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"Lcom/android/adblib/AdbSessionHost$OnlyOnceFilter;", "T", "", "()V", "seenKeys", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "", "filter", "", "key", "block", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "android.sdktools.adblib"})
    private static final class OnlyOnceFilter<T> {
        private final ConcurrentHashMap.KeySetView<T, Boolean> seenKeys = ConcurrentHashMap.newKeySet();

        public final void filter(@NotNull T key2, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(key2, (String)"key");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$filter = false;
            if (this.seenKeys.add(key2)) {
                block.invoke();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/adblib/AdbSessionHost$Property;", "T", "", "name", "", "defaultValue", "isVolatile", "", "(Ljava/lang/String;Ljava/lang/Object;Z)V", "getDefaultValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "()Z", "getName", "()Ljava/lang/String;", "equals", "other", "fromStringValue", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "hashCode", "", "maybeQuoteValue", "(Ljava/lang/Object;)Ljava/lang/String;", "toString", "android.sdktools.adblib"})
    public static abstract class Property<T> {
        @NotNull
        private final String name;
        @NotNull
        private final T defaultValue;
        private final boolean isVolatile;

        public Property(@NotNull String name, @NotNull T defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            this.name = name;
            this.defaultValue = defaultValue;
            this.isVolatile = isVolatile;
        }

        public /* synthetic */ Property(String string, Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, object, bl);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final T getDefaultValue() {
            return this.defaultValue;
        }

        public final boolean isVolatile() {
            return this.isVolatile;
        }

        @NotNull
        public abstract T fromStringValue(@NotNull String var1);

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        @NotNull
        public String toString() {
            return "Property(name=\"" + this.name + "\", type=" + this.defaultValue.getClass().getSimpleName() + ", defaultValue=" + this.maybeQuoteValue(this.defaultValue) + ")";
        }

        private final String maybeQuoteValue(T value) {
            return value instanceof String ? "\"" + value + "\"" : String.valueOf(value);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/adblib/AdbSessionHost$StringProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "", "name", "defaultValue", "isVolatile", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "fromStringValue", "value", "android.sdktools.adblib"})
    public static final class StringProperty
    extends Property<String> {
        public StringProperty(@NotNull String name, @NotNull String defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ StringProperty(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, string2, bl);
        }

        @Override
        @NotNull
        public String fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }
    }
}

