/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ikv;

public final class RecSplitSettings {
    public static final int SUPPLEMENTAL_HASH_SHIFT = 18;
    private static final long SUPPLEMENTAL_HASH_CALLS = 262144L;
    private static final int[] SPLIT_RULE = RecSplitSettings.splitIntegerList();
    private static final int CACHE_SPLITS = 10240;
    private static final int leafSize = 10;
    private final int averageBucketSize;
    private final int[] splits = new int[10240];
    public static final RecSplitSettings DEFAULT_SETTINGS = new RecSplitSettings();

    private static int[] splitIntegerList() {
        String x = "1,1,0,2,2,0,3,3,1,4,4,3,5,5,4,6,6,5,7,7,7,8,8,8,9,9,10,10,10,11,11,-1,0,12,-2,1,13,-3,1,14,-4,1,15,-5,1,16,-8,2,17,-7,2,18,-8,2,19,-9,2,20,-10,2,21,3,4,22,-10,2,23,-10,2,24,3,4,25,-5,2,26,-8,2,27,3,4,28,-8,2,29,-9,2,30,3,5,31,-1,1,32,4,7,33,-3,1,34,-10,2,35,-5,2,36,4,7,37,-7,2,38,-8,2,39,-9,2,40,4,7,41,-1,1,42,-2,1,43,-3,1,44,-4,2,45,5,10,46,-6,2,47,-7,2,48,-8,2,49,-9,2,50,5,10,51,-1,1,52,-2,1,53,-3,1,54,-4,2,55,-5,2,56,-6,2,57,-7,2,58,-8,2,59,-9,2,60,-10,2,61,-1,1,62,-2,1,63,-13,2,64,-4,2,65,-5,2,66,-8,2,67,-7,2,68,-8,2,69,-9,2,70,-10,2,71,-21,3,72,-32,3,73,-23,3,74,-24,3,75,-30,3,76,-36,3,77,-27,3,78,-28,3,79,-29,3,80,-30,3,81,-36,3,82,-32,3,83,-33,3,84,-4,2,85,-40,3,86,-36,3,87,-37,3,88,-38,3,89,-39,3,90,-40,3,91,-1,1,92,-42,3,93,-43,3,94,-4,2,95,-45,3,96,-6,2,97,-47,3,98,-48,3,99,-49,3,100,-50,3,101,-1,1,102,-50,3,103,-50,3,104,-4,2,105,-5,2,106,-6,2,107,-7,2,108,-50,3,109,-50,3,110,-50,3,111,-1,1,112,-52,3,113,-50,3,114,-4,2,115,-5,2,116,-50,3,117,-7,2,118,-50,3,119,-59,3,120,3,7,121,-1,1,122,-2,1,123,-3,1,124,-24,3,125,-5,2,126,-6,2,127,-7,2,128,-8,2,129,-9,2,130,-30,3,131,-36,3,132,-32,3,133,-33,3,134,-4,2,135,-40,3,136,-36,3,137,-30,3,138,-38,3,139,-39,3,140,-40,3,141,-1,1,142,-40,3,143,-43,3,144,-4,2,145,-45,3,146,-6,2,147,-7,2,148,-8,2,149,-9,2,150,3,7,151,-1,0,152,-2,1,153,-3,1,154,-4,2,155,-5,2,156,-6,2,157,-7,2,158,-8,2,159,-9,2,160,-10,2,161,-10,2,162,-2,1,163,-10,2,164,-4,2,165,-5,2,166,-8,2,167,-7,2,168,-8,2,169,-9,2,170,-20,3,171,-21,3,172,-20,3,173,-23,3,174,-24,3,175,-20,3,176,-8,2,177,-27,3,178,-28,3,179,-29,3,180,-30,3,181,-30,3,182,-32,3,183,-30,3,184,-4,2,185,-5,2,186,-36,3,187,-30,3,188,-30,3,189,-30,3,190,-40,3,191,-40,3,192,-40,3,193,-40,3,194,-4,2,195,-45,3,196,-6,2,197,-7,2,198,-8,2,199,-40,3,200,-50,3,201,-50,3,202,-2,1,203,-50,3,204,-4,2,205,-5,2,206,-6,2,207,-7,2,208,-8,2,209,-9,2,210,-10,2,211,-10,2,212,-2,1,213,-10,2,214,-4,2,215,-5,2,216,-8,2,217,-7,2,218,-8,2,219,-9,2,220,-20,3,221,-21,3,222,-32,3,223,-23,3,224,-24,3,225,-30,3,226,-36,3,227,-27,3,228,-28,3,229,-29,3,230,-30,3,231,-30,3,232,-32,3,233,-30,3,234,-4,2,235,-40,3,236,-36,3,237,-30,3,238,-30,3,239,-30,3,240,-90,4,241,-90,4,242,-90,4,243,-90,4,244,-90,4,245,-95,4,246,-90,4,247,-90,4,248,-90,4,249,-99,4,250,-100,4,251,-100,4,252,-100,4,253,-100,4,254,-100,4,255,-100,4,256,-100,4,257,-100,4,258,-100,4,259,-100,4,260,-110,4,261,-110,4,262,-110,4,263,-110,4,264,-4,2,265,-110,4,266,-100,4,267,-110,4,268,-110,4,269,-110,4,270,-120,4,271,-120,4,272,-120,4,273,-120,4,274,-100,4,275,-120,4,276,-120,4,277,-120,4,278,-120,4,279,-120,4,280,-130,4,281,-130,4,282,-132,4,283,-130,4,284,-4,2,285,-135,4,286,-136,4,287,-130,4,288,-130,4,289,-139,4,290,-140,4,291,-140,4,292,-140,4,293,-140,4,294,-4,2,295,-145,4,296,-146,4,297,-147,4,298,-148,4,299,-149,4,300,-150,4,301,-150,4,302,-150,4,303,-150,4,304,-4,2,305,-150,4,306,-150,4,307,-150,4,308,-150,4,309,-150,4,310,-150,4,311,-151,4,312,-152,4,313,-153,4,314,-4,2,315,-5,2,316,-158,4,317,-157,4,318,-158,4,319,-159,4,320,-20,3,321,-21,3,322,-20,3,323,-150,4,324,-150,4,325,-20,3,326,-160,4,327,-150,4,328,-150,4,329,-150,4,330,-150,4,331,-151,4,332,-150,4,333,-153,4,334,-4,2,335,-5,2,336,-150,4,337,-157,4,338,-158,4,339,-159,4,340,-150,4,341,-151,4,342,-152,4,343,-153,4,344,-4,2,345,-150,4,346,-156,4,347,-157,4,348,-158,4,349,-159,4,350,-150,4,351,-151,4,352,-152,4,353,-153,4,354,-4,2,355,-5,2,356,-156,4,357,-157,4,358,-158,4,359,-159,4,360,-160,4,361,-161,4,362,-162,4,363,-163,4,364,-4,2,365,-5,2,366,-166,4,367,-167,4,368,-168,4,369,-169,4,370,-20,3,371,-21,3,372,-182,4,373,-23,3,374,-24,3,375,-180,4,376,-186,4,377,-177,4,378,-178,4,379,-179,4,380,-180,4,381,-181,4,382,-182,4,383,-183,4,384,-4,2,385,-190,4,386,-86,4,387,-187,4,388,-188,4,389,-89,4,390,-90,4,391,-90,4,392,-90,4,393,-90,4,394,-4,2,395,-95,4,396,-90,4,397,-90,4,398,-90,4,399,-99,4,400,-100,4,401,-100,4,402,-100,4,403,-100,4,404,-4,2,405,-100,4,406,-100,4,407,-100,4,408,-100,4,409,-100,4,410,-110,4,411,-110,4,412,-110,4,413,-110,4,414,-4,2,415,-110,4,416,-100,4,417,-110,4,418,-110,4,419,-110,4,420,-120,4,421,-120,4,422,-120,4,423,-120,4,424,-100,4,425,-5,2,426,-120,4,427,-120,4,428,-120,4,429,-120,4,430,-100,4,431,-100,4,432,-100,4,433,-100,4,434,-4,2,435,-135,4,436,-136,4,437,-100,4,438,-100,4,439,-100,4,440,-140,4,441,-140,4,442,-140,4,443,-140,4,444,-4,2,445,-145,4,446,-140,4,447,-140,4,448,-140,4,449,-140,4,450,3,9,451,-1,0,452,-2,1,453,-3,1,454,-4,2,455,-5,2,456,-6,2,457,-7,2,458,-8,2,459,-9,2,460,-10,2,461,-10,2,462,-2,1,463,-10,2,464,-4,2,465,-5,2,466,-8,2,467,-7,2,468,-8,2,469,-19,3,470,-20,3,471,-21,3,472,-20,3,473,-23,3,474,-24,3,475,-20,3,476,-8,2,477,-27,3,478,-28,3,479,-29,3,480,-30,3,481,-30,3,482,-32,3,483,-30,3,484,-4,2,485,-5,2,486,-36,3,487,-7,2,488,-30,3,489,-30,3,490,-40,3,491,-40,3,492,-2,1,493,-40,3,494,-4,2,495,-45,3,496,-6,2,497,-7,2,498,-8,2,499,-9,2,500,-50,3,501,-50,3,502,-2,1,503,-50,3,504,-4,2,505,-5,2,506,-6,2,507,-7,2,508,-58,4,509,-59,4,510,-60,4,511,-60,4,512,-60,4,513,-60,4,514,-60,4,515,-60,4,516,-66,4,517,-67,4,518,-68,4,519,-69,4,520,-70,4,521,-71,4,522,-32,3,523,-73,4,524,-74,4,525,-75,4,526,-76,4,527,-77,4,528,-78,4,529,-79,4,530,-80,4,531,-80,4,532,-82,4,533,-80,4,534,-4,2,535,-85,4,536,-86,4,537,-87,4,538,-88,4,539,-89,4,540,-90,4,541,-90,4,542,-90,4,543,-90,4,544,-4,2,545,-95,4,546,-90,4,547,-90,4,548,-98,4,549,-99,4,550,-100,4,551,-100,4,552,-100,4,553,-100,4,554,-4,2,555,-5,2,556,-100,4,557,-100,4,558,-100,4,559,-109,4,560,-110,4,561,-110,4,562,-110,4,563,-110,4,564,-4,2,565,-5,2,566,-100,4,567,-110,4,568,-110,4,569,-110,4,570,-120,4,571,-120,4,572,-120,4,573,-120,4,574,-100,4,575,-5,2,576,-6,2,577,-120,4,578,-120,4,579,-120,4,580,-130,4,581,-130,4,582,-132,4,583,-130,4,584,-4,2,585,-135,4,586,-136,4,587,-130,4,588,-130,4,589,-139,4,590,-140,4,591,-140,4,592,-140,4,593,-140,4,594,-4,2,595,-145,4,596,-6,2,597,-140,4,598,-148,4,599,-149,4,600,-150,4,601,-151,4,602,-152,4,603,-153,4,604,-4,2,605,-5,2,606,-6,2,607,-7,2,608,-158,4,609,-159,4,610,-160,4,611,-161,4,612,-162,4,613,-163,4,614,-4,2,615,-5,2,616,-166,4,617,-7,2,618,-168,4,619,-169,4,620,-20,3,621,-21,3,622,-20,3,623,-23,3,624,-24,3,625,-20,3,626,-168,4,627,-27,3,628,-28,3,629,-29,3,630,-30,3,631,-30,3,632,-150,4,633,-30,3,634,-4,2,635,-5,2,636,-186,4,637,-7,2,638,-30,3,639,-30,3,640,-190,4,641,-191,4,642,-2,1,643,-193,4,644,-4,2,645,-195,4,646,-6,2,647,-7,2,648,-8,2,649,-199,4,650,-200,4,651,-201,4,652,-2,1,653,-203,4,654,-4,2,655,-5,2,656,-6,2,657,-7,2,658,-8,2,659,-59,4,660,-60,4,661,-60,4,662,-60,4,663,-60,4,664,-60,4,665,-60,4,666,-66,4,667,-67,4,668,-68,4,669,-69,4,670,-70,4,671,-21,3,672,-32,3,673,-23,3,674,-74,4,675,-75,4,676,-76,4,677,-77,4,678,-78,4,679,-79,4,680,-80,4,681,-80,4,682,-82,4,683,-80,4,684,-4,2,685,-85,4,686,-86,4,687,-87,4,688,-88,4,689,-89,4,690,-90,4,691,-90,4,692,-90,4,693,-90,4,694,-4,2,695,-95,4,696,-90,4,697,-90,4,698,-98,4,699,-99,4,700,-100,4,701,-100,4,702,-100,4,703,-100,4,704,-4,2,705,-5,2,706,-100,4,707,-100,4,708,-100,4,709,-109,4,710,-110,4,711,-110,4,712,-110,4,713,-110,4,714,-4,2,715,-5,2,716,-100,4,717,-110,4,718,-110,4,719,-110,4,720,-120,4,721,-120,4,722,-120,4,723,-120,4,724,-100,4,725,-5,2,726,-6,2,727,-120,4,728,-120,4,729,-120,4,730,-130,4,731,-130,4,732,-132,4,733,-130,4,734,-4,2,735,-135,4,736,-136,4,737,-130,4,738,-130,4,739,-139,4,740,-140,4,741,-140,4,742,-140,4,743,-140,4,744,-4,2,745,-145,4,746,-6,2,747,-7,2,748,-140,4,749,-149,4,750,-150,4,751,-150,4,752,-150,4,753,-150,4,754,-4,2,755,-5,2,756,-6,2,757,-7,2,758,-150,4,759,-150,4,760,-150,4,761,-151,4,762,-150,4,763,-150,4,764,-4,2,765,-5,2,766,-150,4,767,-7,2,768,-150,4,769,-150,4,770,-20,3,771,-21,3,772,-20,3,773,-23,3,774,-24,3,775,-20,3,776,-150,4,777,-27,3,778,-28,3,779,-29,3,780,-30,3,781,-30,3,782,-150,4,783,-30,3,784,-4,2,785,-5,2,786,-150,4,787,-7,2,788,-30,3,789,-30,3,790,-150,4,791,-151,4,792,-152,4,793,-153,4,794,-4,2,795,-150,4,796,-6,2,797,-7,2,798,-150,4,799,-159,4,800,-150,4,801,-151,4,802,-152,4,803,-153,4,804,-4,2,805,-5,2,806,-6,2,807,-7,2,808,-150,4,809,-59,4,810,-60,4,811,-60,4,812,-60,4,813,-60,4,814,-60,4,815,-60,4,816,-66,4,817,-67,4,818,-68,4,819,-69,4,820,-70,4,821,-21,3,822,-150,4,823,-70,4,824,-74,4,825,-75,4,826,-76,4,827,-77,4,828,-78,4,829,-79,4,830,-80,4,831,-80,4,832,-82,4,833,-80,4,834,-4,2,835,-85,4,836,-86,4,837,-87,4,838,-88,4,839,-89,4,840,-90,4,841,-90,4,842,-90,4,843,-90,4,844,-4,2,845,-95,4,846,-90,4,847,-90,4,848,-98,4,849,-99,4,850,-100,4,851,-100,4,852,-100,4,853,-100,4,854,-4,2,855,-5,2,856,-100,4,857,-100,4,858,-100,4,859,-100,4,860,-110,4,861,-110,4,862,-110,4,863,-110,4,864,-4,2,865,-5,2,866,-100,4,867,-110,4,868,-110,4,869,-110,4,870,-120,4,871,-120,4,872,-120,4,873,-120,4,874,-100,4,875,-5,2,876,-6,2,877,-120,4,878,-120,4,879,-120,4,880,-100,4,881,-100,4,882,-132,4,883,-100,4,884,-4,2,885,-135,4,886,-136,4,887,-100,4,888,-100,4,889,-100,4,890,-140,4,891,-140,4,892,-140,4,893,-140,4,894,-4,2,895,-145,4,896,-6,2,897,-7,2,898,-140,4,899,-140,4,900,-450,5,901,-450,5,902,-450,5,903,-450,5,904,-450,5,905,-450,5,906,-450,5,907,-450,5,908,-450,5,909,-450,5,910,-450,5,911,-451,5,912,-452,5,913,-453,5,914,-454,5,915,-455,5,916,-458,5,917,-457,5,918,-458,5,919,-450,5,920,-450,5,921,-450,5,922,-452,5,923,-450,5,924,-450,5,925,-455,5,926,-460,5,927,-450,5,928,-450,5,929,-450,5,930,-450,5,931,-451,5,932,-450,5,933,-453,5,934,-454,5,935,-455,5,936,-450,5,937,-457,5,938,-458,5,939,-459,5,940,-450,5,941,-451,5,942,-452,5,943,-453,5,944,-454,5,945,-450,5,946,-456,5,947,-457,5,948,-458,5,949,-459,5,950,-450,5,951,-451,5,952,-452,5,953,-453,5,954,-454,5,955,-455,5,956,-456,5,957,-457,5,958,-58,4,959,-59,4,960,-60,4,961,-60,4,962,-60,4,963,-60,4,964,-60,4,965,-60,4,966,-450,5,967,-450,5,968,-450,5,969,-450,5,970,-450,5,971,-450,5,972,-482,5,973,-450,5,974,-450,5,975,-450,5,976,-450,5,977,-450,5,978,-450,5,979,-450,5,980,-450,5,981,-451,5,982,-450,5,983,-453,5,984,-454,5,985,-450,5,986,-450,5,987,-450,5,988,-450,5,989,-450,5,990,-450,5,991,-451,5,992,-452,5,993,-453,5,994,-454,5,995,-450,5,996,-456,5,997,-457,5,998,-450,5,999,-450,5,1000,-450,5,1001,-451,5,1002,-452,5,1003,-453,5,1004,-454,5,1005,-455,5,1006,-456,5,1007,-457,5,1008,-458,5,1009,-450,5,1010,-450,5,1011,-451,5,1012,-452,5,1013,-453,5,1014,-454,5,1015,-455,5,1016,-466,5,1017,-457,5,1018,-458,5,1019,-459,5,1020,-450,5,1021,-451,5,1022,-452,5,1023,-453,5,1024,-474,5,1025,-455,5,1026,-456,5,1027,-457,5,1028,-458,5,1029,-459,5,1030,-450,5,1031,-451,5,1032,-450,5,1033,-453,5,1034,-4,2,1035,-450,5,1036,-450,5,1037,-457,5,1038,-458,5,1039,-450,5,1040,-450,5,1041,-451,5,1042,-452,5,1043,-453,5,1044,-4,2,1045,-450,5,1046,-456,5,1047,-457,5,1048,-450,5,1049,-450,5,1050,-450,5,1051,-450,5,1052,-450,5,1053,-450,5,1054,-4,2,1055,-455,5,1056,-456,5,1057,-457,5,1058,-450,5,1059,-450,5,1060,-450,5,1061,-450,5,1062,-452,5,1063,-450,5,1064,-4,2,1065,-455,5,1066,-458,5,1067,-457,5,1068,-458,5,1069,-450,5,1070,-470,5,1071,-471,5,1072,-470,5,1073,-473,5,1074,-474,5,1075,-475,5,1076,-466,5,1077,-477,5,1078,-478,5,1079,-479,5,1080,-480,5,1081,-480,5,1082,-482,5,1083,-480,5,1084,-4,2,1085,-485,5,1086,-486,5,1087,-487,5,1088,-480,5,1089,-480,5,1090,-450,5,1091,-450,5,1092,-452,5,1093,-450,5,1094,-4,2,1095,-450,5,1096,-456,5,1097,-457,5,1098,-458,5,1099,-459,5,1100,-450,5,1101,-450,5,1102,-452,5,1103,-450,5,1104,-4,2,1105,-455,5,1106,-456,5,1107,-457,5,1108,-458,5,1109,-59,4,1110,-60,4,1111,-60,4,1112,-60,4,1113,-60,4,1114,-60,4,1115,-60,4,1116,-66,4,1117,-67,4,1118,-68,4,1119,-69,4,1120,-70,4,1121,-471,5,1122,-482,5,1123,-473,5,1124,-474,5,1125,-450,5,1126,-450,5,1127,-450,5,1128,-450,5,1129,-450,5,1130,-530,5,1131,-530,5,1132,-532,5,1133,-450,5,1134,-4,2,1135,-535,5,1136,-536,5,1137,-537,5,1138,-538,5,1139,-539,5,1140,-540,5,1141,-540,5,1142,-540,5,1143,-540,5,1144,-4,2,1145,-545,5,1146,-546,5,1147,-547,5,1148,-548,5,1149,-549,5,1150,-550,5,1151,-550,5,1152,-550,5,1153,-550,5,1154,-4,2,1155,-555,5,1156,-556,5,1157,-557,5,1158,-550,5,1159,-559,5,1160,-560,5,1161,-560,5,1162,-560,5,1163,-560,5,1164,-4,2,1165,-565,5,1166,-558,5,1167,-567,5,1168,-560,5,1169,-560,5,1170,-570,5,1171,-570,5,1172,-570,5,1173,-570,5,1174,-574,5,1175,-575,5,1176,-576,5,1177,-577,5,1178,-570,5,1179,-570,5,1180,-580,5,1181,-580,5,1182,-582,5,1183,-580,5,1184,-4,2,1185,-585,5,1186,-586,5,1187,-587,5,1188,-580,5,1189,-589,5,1190,-590,5,1191,-590,5,1192,-590,5,1193,-590,5,1194,-4,2,1195,-595,5,1196,-596,5,1197,-597,5,1198,-598,5,1199,-599,5,1200,-600,5,1201,-600,5,1202,-600,5,1203,-600,5,1204,-4,2,1205,-600,5,1206,-600,5,1207,-600,5,1208,-600,5,1209,-600,5,1210,-600,5,1211,-601,5,1212,-602,5,1213,-603,5,1214,-4,2,1215,-605,5,1216,-608,5,1217,-607,5,1218,-608,5,1219,-609,5,1220,-600,5,1221,-600,5,1222,-602,5,1223,-600,5,1224,-600,5,1225,-605,5,1226,-610,5,1227,-600,5,1228,-600,5,1229,-600,5,1230,-600,5,1231,-601,5,1232,-600,5,1233,-603,5,1234,-4,2,1235,-605,5,1236,-600,5,1237,-607,5,1238,-608,5,1239,-609,5,1240,-600,5,1241,-601,5,1242,-602,5,1243,-603,5,1244,-4,2,1245,-600,5,1246,-606,5,1247,-607,5,1248,-608,5,1249,-609,5,1250,-600,5,1251,-601,5,1252,-602,5,1253,-603,5,1254,-4,2,1255,-605,5,1256,-606,5,1257,-607,5,1258,-608,5,1259,-59,4,1260,-60,4,1261,-60,4,1262,-60,4,1263,-60,4,1264,-60,4,1265,-60,4,1266,-66,4,1267,-67,4,1268,-68,4,1269,-69,4,1270,-70,4,1271,-621,5,1272,-632,5,1273,-623,5,1274,-74,4,1275,-75,4,1276,-76,4,1277,-77,4,1278,-78,4,1279,-79,4,1280,-80,4,1281,-80,4,1282,-82,4,1283,-80,4,1284,-4,2,1285,-85,4,1286,-600,5,1287,-600,5,1288,-600,5,1289,-600,5,1290,-600,5,1291,-600,5,1292,-600,5,1293,-600,5,1294,-4,2,1295,-600,5,1296,-600,5,1297,-600,5,1298,-600,5,1299,-600,5,1300,-600,5,1301,-601,5,1302,-602,5,1303,-603,5,1304,-4,2,1305,-5,2,1306,-606,5,1307,-607,5,1308,-608,5,1309,-600,5,1310,-600,5,1311,-601,5,1312,-602,5,1313,-603,5,1314,-4,2,1315,-5,2,1316,-608,5,1317,-607,5,1318,-608,5,1319,-609,5,1320,-600,5,1321,-601,5,1322,-602,5,1323,-603,5,1324,-624,5,1325,-5,2,1326,-606,5,1327,-607,5,1328,-608,5,1329,-609,5,1330,-600,5,1331,-601,5,1332,-600,5,1333,-603,5,1334,-4,2,1335,-600,5,1336,-600,5,1337,-607,5,1338,-608,5,1339,-600,5,1340,-600,5,1341,-601,5,1342,-602,5,1343,-603,5,1344,-4,2,1345,-600,5,1346,-606,5,1347,-607,5,1348,-608,5,1349,-609,5,1350,3,10,1351,-1,0,1352,-2,1,1353,-3,1,1354,-4,2,1355,-5,2,1356,-6,2,1357,-7,2,1358,-8,2,1359,-9,2,1360,-10,2,1361,-10,2,1362,-2,1,1363,-10,2,1364,-4,2,1365,-5,2,1366,-8,2,1367,-7,2,1368,-8,2,1369,-19,3,1370,-20,3,1371,-21,3,1372,-20,3,1373,-23,3,1374,-24,3,1375,-20,3,1376,-8,2,1377,-27,3,1378,-28,3,1379,-29,3,1380,-30,3,1381,-30,3,1382,-32,3,1383,-30,3,1384,-4,2,1385,-5,2,1386,-36,3,1387,-7,2,1388,-30,3,1389,-30,3,1390,-40,3,1391,-40,3,1392,-2,1,1393,-40,3,1394,-4,2,1395,-45,3,1396,-6,2,1397,-7,2,1398,-8,2,1399,-9,2,1400,-50,4,1401,-50,4,1402,-50,4,1403,-50,4,1404,-50,4,1405,-50,4,1406,-56,4,1407,-57,4,1408,-58,4,1409,-59,4,1410,-60,4,1411,-60,4,1412,-60,4,1413,-60,4,1414,-60,4,1415,-60,4,1416,-66,4,1417,-67,4,1418,-68,4,1419,-69,4,1420,-70,4,1421,-71,4,1422,-72,4,1423,-73,4,1424,-74,4,1425,-75,4,1426,-76,4,1427,-77,4,1428,-78,4,1429,-79,4,1430,-80,4,1431,-80,4,1432,-82,4,1433,-80,4,1434,-4,2,1435,-85,4,1436,-86,4,1437,-87,4,1438,-88,4,1439,-89,4,1440,-90,4,1441,-90,4,1442,-90,4,1443,-90,4,1444,-4,2,1445,-95,4,1446,-90,4,1447,-90,4,1448,-98,4,1449,-99,4,1450,-100,4,1451,-100,4,1452,-100,4,1453,-100,4,1454,-4,2,1455,-5,2,1456,-100,4,1457,-100,4,1458,-100,4,1459,-109,4,1460,-110,4,1461,-110,4,1462,-110,4,1463,-110,4,1464,-4,2,1465,-5,2,1466,-100,4,1467,-110,4,1468,-110,4,1469,-110,4,1470,-120,4,1471,-120,4,1472,-120,4,1473,-120,4,1474,-100,4,1475,-5,2,1476,-6,2,1477,-120,4,1478,-120,4,1479,-120,4,1480,-100,4,1481,-100,4,1482,-100,4,1483,-100,4,1484,-4,2,1485,-135,4,1486,-136,4,1487,-100,4,1488,-100,4,1489,-109,4,1490,-140,4,1491,-140,4,1492,-140,4,1493,-140,4,1494,-4,2,1495,-145,4,1496,-6,2,1497,-7,2,1498,-140,4,1499,-149,4,1500,-150,4,1501,-151,4,1502,-2,1,1503,-153,4,1504,-4,2,1505,-5,2,1506,-6,2,1507,-7,2,1508,-8,2,1509,-159,4,1510,-160,4,1511,-161,4,1512,-2,1,1513,-163,4,1514,-4,2,1515,-5,2,1516,-8,2,1517,-7,2,1518,-8,2,1519,-19,3,1520,-20,3,1521,-21,3,1522,-20,3,1523,-23,3,1524,-24,3,1525,-20,3,1526,-8,2,1527,-27,3,1528,-28,3,1529,-29,3,1530,-30,3,1531,-30,3,1532,-32,3,1533,-30,3,1534,-4,2,1535,-5,2,1536,-150,4,1537,-7,2,1538,-30,3,1539,-30,3,1540,-150,4,1541,-151,4,1542,-2,1,1543,-153,4,1544,-4,2,1545,-195,4,1546,-6,2,1547,-7,2,1548,-8,2,1549,-159,4,1550,-50,4,1551,-50,4,1552,-50,4,1553,-50,4,1554,-50,4,1555,-50,4,1556,-56,4,1557,-57,4,1558,-58,4,1559,-59,4,1560,-60,4,1561,-60,4,1562,-60,4,1563,-60,4,1564,-60,4,1565,-60,4,1566,-66,4,1567,-67,4,1568,-68,4,1569,-69,4,1570,-70,4,1571,-71,4,1572,-72,4,1573,-70,4,1574,-74,4,1575,-75,4,1576,-76,4,1577,-77,4,1578,-78,4,1579,-79,4,1580,-80,4,1581,-80,4,1582,-82,4,1583,-80,4,1584,-4,2,1585,-85,4,1586,-86,4,1587,-87,4,1588,-88,4,1589,-89,4,1590,-90,4,1591,-90,4,1592,-90,4,1593,-90,4,1594,-4,2,1595,-95,4,1596,-90,4,1597,-90,4,1598,-98,4,1599,-99,4,1600,-100,4,1601,-100,4,1602,-100,4,1603,-100,4,1604,-4,2,1605,-5,2,1606,-100,4,1607,-100,4,1608,-100,4,1609,-109,4,1610,-110,4,1611,-110,4,1612,-110,4,1613,-110,4,1614,-4,2,1615,-5,2,1616,-100,4,1617,-110,4,1618,-110,4,1619,-110,4,1620,-120,4,1621,-120,4,1622,-120,4,1623,-120,4,1624,-100,4,1625,-5,2,1626,-6,2,1627,-7,2,1628,-120,4,1629,-120,4,1630,-100,4,1631,-100,4,1632,-100,4,1633,-100,4,1634,-4,2,1635,-135,4,1636,-136,4,1637,-100,4,1638,-100,4,1639,-109,4,1640,-140,4,1641,-140,4,1642,-2,1,1643,-293,5,1644,-4,2,1645,-295,5,1646,-296,5,1647,-297,5,1648,-298,5,1649,-299,5,1650,-300,5,1651,-301,5,1652,-302,5,1653,-303,5,1654,-304,5,1655,-305,5,1656,-306,5,1657,-307,5,1658,-308,5,1659,-309,5,1660,-310,5,1661,-311,5,1662,-312,5,1663,-313,5,1664,-4,2,1665,-315,5,1666,-316,5,1667,-317,5,1668,-318,5,1669,-319,5,1670,-320,5,1671,-321,5,1672,-322,5,1673,-323,5,1674,-324,5,1675,-325,5,1676,-326,5,1677,-327,5,1678,-328,5,1679,-329,5,1680,-330,5,1681,-331,5,1682,-332,5,1683,-333,5,1684,-4,2,1685,-335,5,1686,-336,5,1687,-337,5,1688,-338,5,1689,-339,5,1690,-340,5,1691,-341,5,1692,-342,5,1693,-343,5,1694,-4,2,1695,-345,5,1696,-346,5,1697,-347,5,1698,-348,5,1699,-349,5,1700,-350,5,1701,-351,5,1702,-352,5,1703,-353,5,1704,-4,2,1705,-355,5,1706,-356,5,1707,-357,5,1708,-358,5,1709,-359,5,1710,-360,5,1711,-361,5,1712,-362,5,1713,-363,5,1714,-4,2,1715,-365,5,1716,-366,5,1717,-367,5,1718,-368,5,1719,-369,5,1720,-370,5,1721,-371,5,1722,-372,5,1723,-373,5,1724,-374,5,1725,-375,5,1726,-376,5,1727,-377,5,1728,-378,5,1729,-379,5,1730,-380,5,1731,-381,5,1732,-382,5,1733,-383,5,1734,-4,2,1735,-385,5,1736,-386,5,1737,-387,5,1738,-388,5,1739,-389,5,1740,-390,5,1741,-391,5,1742,-392,5,1743,-393,5,1744,-4,2,1745,-395,5,1746,-396,5,1747,-397,5,1748,-398,5,1749,-399,5,1750,-400,5,1751,-401,5,1752,-402,5,1753,-403,5,1754,-4,2,1755,-405,5,1756,-406,5,1757,-407,5,1758,-408,5,1759,-409,5,1760,-410,5,1761,-411,5,1762,-412,5,1763,-413,5,1764,-4,2,1765,-415,5,1766,-416,5,1767,-417,5,1768,-418,5,1769,-419,5,1770,-420,5,1771,-421,5,1772,-422,5,1773,-423,5,1774,-424,5,1775,-5,2,1776,-426,5,1777,-427,5,1778,-428,5,1779,-429,5,1780,-430,5,1781,-431,5,1782,-432,5,1783,-433,5,1784,-4,2,1785,-435,5,1786,-436,5,1787,-437,5,1788,-438,5,1789,-439,5,1790,-440,5,1791,-441,5,1792,-442,5,1793,-443,5,1794,-4,2,1795,-445,5,1796,-446,5,1797,-447,5,1798,-448,5,1799,-449,5,1800,-450,5,1801,-451,5,1802,-452,5,1803,-453,5,1804,-4,2,1805,-5,2,1806,-456,5,1807,-457,5,1808,-458,5,1809,-459,5,1810,-460,5,1811,-461,5,1812,-462,5,1813,-463,5,1814,-4,2,1815,-5,2,1816,-466,5,1817,-467,5,1818,-468,5,1819,-19,3,1820,-20,3,1821,-21,3,1822,-20,3,1823,-473,5,1824,-474,5,1825,-20,3,1826,-476,5,1827,-477,5,1828,-478,5,1829,-479,5,1830,-480,5,1831,-481,5,1832,-482,5,1833,-483,5,1834,-4,2,1835,-5,2,1836,-486,5,1837,-487,5,1838,-488,5,1839,-489,5,1840,-490,5,1841,-491,5,1842,-492,5,1843,-493,5,1844,-4,2,1845,-495,5,1846,-496,5,1847,-497,5,1848,-498,5,1849,-499,5,1850,-500,5,1851,-501,5,1852,-502,5,1853,-503,5,1854,-4,2,1855,-5,2,1856,-506,5,1857,-57,4,1858,-58,4,1859,-59,4,1860,-60,4,1861,-60,4,1862,-60,4,1863,-60,4,1864,-60,4,1865,-60,4,1866,-66,4,1867,-67,4,1868,-68,4,1869,-69,4,1870,-70,4,1871,-71,4,1872,-522,5,1873,-73,4,1874,-74,4,1875,-75,4,1876,-76,4,1877,-77,4,1878,-78,4,1879,-79,4,1880,-80,4,1881,-80,4,1882,-82,4,1883,-80,4,1884,-4,2,1885,-85,4,1886,-86,4,1887,-80,4,1888,-88,4,1889,-89,4,1890,-90,4,1891,-90,4,1892,-90,4,1893,-90,4,1894,-4,2,1895,-450,5,1896,-90,4,1897,-90,4,1898,-90,4,1899,-450,5,1900,-450,5,1901,-451,5,1902,-452,5,1903,-453,5,1904,-4,2,1905,-5,2,1906,-456,5,1907,-457,5,1908,-458,5,1909,-559,5,1910,-560,5,1911,-561,5,1912,-562,5,1913,-563,5,1914,-4,2,1915,-5,2,1916,-466,5,1917,-567,5,1918,-568,5,1919,-569,5,1920,-570,5,1921,-571,5,1922,-572,5,1923,-573,5,1924,-474,5,1925,-5,2,1926,-6,2,1927,-577,5,1928,-578,5,1929,-579,5,1930,-580,5,1931,-581,5,1932,-582,5,1933,-483,5,1934,-4,2,1935,-585,5,1936,-586,5,1937,-487,5,1938,-488,5,1939,-589,5,1940,-590,5,1941,-591,5,1942,-592,5,1943,-593,5,1944,-4,2,1945,-595,5,1946,-6,2,1947,-597,5,1948,-598,5,1949,-599,5,1950,-600,5,1951,-601,5,1952,-602,5,1953,-603,5,1954,-4,2,1955,-5,2,1956,-6,2,1957,-607,5,1958,-608,5,1959,-609,5,1960,-610,5,1961,-611,5,1962,-612,5,1963,-613,5,1964,-4,2,1965,-5,2,1966,-616,5,1967,-617,5,1968,-618,5,1969,-619,5,1970,-20,3,1971,-21,3,1972,-20,3,1973,-23,3,1974,-24,3,1975,-20,3,1976,-626,5,1977,-600,5,1978,-628,5,1979,-629,5,1980,-630,5,1981,-631,5,1982,-632,5,1983,-633,5,1984,-4,2,1985,-5,2,1986,-636,5,1987,-637,5,1988,-638,5,1989,-639,5,1990,-640,5,1991,-641,5,1992,-642,5,1993,-643,5,1994,-4,2,1995,-645,5,1996,-6,2,1997,-647,5,1998,-648,5,1999,-649,5,2000,-650,5,2001,-651,5,2002,-652,5,2003,-653,5,2004,-4,2,2005,-5,2,2006,-6,2,2007,-657,5,2008,-58,4,2009,-59,4,2010,-60,4,2011,-60,4,2012,-60,4,2013,-60,4,2014,-60,4,2015,-60,4,2016,-66,4,2017,-67,4,2018,-68,4,2019,-69,4,2020,-70,4,2021,-21,3,2022,-72,4,2023,-70,4,2024,-74,4,2025,-75,4,2026,-76,4,2027,-77,4,2028,-78,4,2029,-79,4,2030,-80,4,2031,-80,4,2032,-82,4,2033,-80,4,2034,-4,2,2035,-85,4,2036,-86,4,2037,-87,4,2038,-88,4,2039,-89,4,2040,-90,4,2041,-90,4,2042,-90,4,2043,-90,4,2044,-4,2,2045,-95,4,2046,-90,4,2047,-90,4,0,0,0";
        String[] array = x.split(",");
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Integer.parseInt(array[i], 10);
        }
        return result;
    }

    public RecSplitSettings() {
        this(64);
    }

    public RecSplitSettings(int averageBucketSize) {
        int i;
        if (averageBucketSize < 2 || averageBucketSize > 65536) {
            throw new IllegalArgumentException("averageBucketSize out of range: " + averageBucketSize);
        }
        this.averageBucketSize = averageBucketSize;
        for (i = 0; i < SPLIT_RULE.length; i += 3) {
            int size = SPLIT_RULE[i];
            this.splits[size] = SPLIT_RULE[i + 1];
        }
        for (i = 0; i <= 10; ++i) {
            this.splits[i] = i;
        }
        int last = 10;
        for (int i2 = 10; i2 < 10240; ++i2) {
            if (this.splits[i2] != 0) {
                last = i2;
                continue;
            }
            this.splits[i2] = -last;
        }
    }

    public int getSplit(int size) {
        return this.splits[size];
    }

    public static boolean needNewUniversalHashIndex(long index) {
        return (index & 0x3FFFFL) == 0L;
    }

    public static long getUniversalHashIndex(long index) {
        return index >>> 18;
    }

    public int getLeafSize() {
        return 10;
    }

    public int getAverageBucketSize() {
        return this.averageBucketSize;
    }

    public static long supplementalHash(long hash, long index) {
        long x = hash + index;
        x = (x ^ x >>> 30) * -4658895280553007687L;
        x = (x ^ x >>> 27) * -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    public static int getBucketCount(int size, int averageBucketSize) {
        return (size + averageBucketSize - 1) / averageBucketSize;
    }

    public static int reduce(long hash, int n) {
        return (int)(((long)((int)hash) & 0xFFFFFFFFL) * (long)n >>> 32);
    }
}

