/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Promise<T> {
    @Deprecated
    @NotNull
    public static <T> Promise<T> resolve(@Nullable T result) {
        try {
            Method method = Promise.class.getClassLoader().loadClass("org.jetbrains.concurrency.Promises").getMethod("resolvedPromise", Object.class);
            method.setAccessible(true);
            return (Promise)method.invoke(null, result);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> var1);

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> var1);

    @NotNull
    public Promise<T> onSuccess(@NotNull java.util.function.Consumer<? super T> var1);

    @Deprecated
    @NotNull
    default public Promise<T> done(@NotNull Consumer<? super T> done) {
        return this.onSuccess(it -> done.consume(it));
    }

    @NotNull
    public Promise<T> onError(@NotNull java.util.function.Consumer<? super Throwable> var1);

    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> var1);

    @NotNull
    public Promise<T> onProcessed(@NotNull java.util.function.Consumer<? super T> var1);

    @NotNull
    public State getState();

    @Nullable
    public T blockingGet(int var1, @NotNull TimeUnit var2) throws TimeoutException, ExecutionException;

    @Nullable
    default public T blockingGet(int timeout) throws TimeoutException, ExecutionException {
        return this.blockingGet(timeout, TimeUnit.MILLISECONDS);
    }

    default public boolean isSucceeded() {
        return this.getState() == State.SUCCEEDED;
    }

    public static enum State {
        PENDING,
        SUCCEEDED,
        REJECTED;

    }
}

