/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.reference.SoftReference;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.SerializationException;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlSerializerImpl {
    static final XmlSerializer serializer = new XmlSerializer();

    @NotNull
    static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter) throws SerializationException {
        try {
            Class<?> aClass = object.getClass();
            Binding binding = serializer.getRootBinding(aClass, aClass);
            if (binding instanceof BeanBinding) {
                return ((BeanBinding)binding).serialize(object, true, filter);
            }
            return (Element)binding.serialize(object, null, filter);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
    }

    @Nullable
    static Object convert(@Nullable String value, @NotNull Class<?> valueClass) {
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value;
    }

    static void doSet(@NotNull Object host, @Nullable String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            accessor.set(host, ClassUtil.stringToEnum(value, valueClass, false));
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            } else if (XmlSerializerImpl.callFromStringIfDefined(host, value, accessor, valueClass)) {
                return;
            }
            accessor.set(host, deserializedValue);
        }
    }

    private static boolean callFromStringIfDefined(@NotNull Object host, @NotNull String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        Method fromText;
        try {
            fromText = valueClass.getMethod("fromText", String.class);
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
        try {
            fromText.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            accessor.set(host, fromText.invoke(null, value));
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    @NotNull
    static String convertToString(@NotNull Object value) {
        if (value instanceof Date) {
            return Long.toString(((Date)value).getTime());
        }
        return value.toString();
    }

    @NotNull
    static String getTextValue(@NotNull Element element, @NotNull String defaultText) {
        List<Content> content = element.getContent();
        int size = content.size();
        StringBuilder builder = null;
        for (int i = 0; i < size; ++i) {
            Content child = content.get(i);
            if (!(child instanceof Text)) continue;
            String value = child.getValue();
            if (builder == null && i == size - 1) {
                return value;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(value);
        }
        return builder == null ? defaultText : builder.toString();
    }

    static class XmlSerializer
    extends XmlSerializerBase {
        private Reference<Map<Type, Binding>> ourBindings;

        XmlSerializer() {
        }

        @NotNull
        private Map<Type, Binding> getBindingCacheMap() {
            Map<Type, Binding> map = SoftReference.dereference(this.ourBindings);
            if (map == null) {
                map = new ConcurrentHashMap<Type, Binding>();
                this.ourBindings = new java.lang.ref.SoftReference<Map<Type, Binding>>(map);
            }
            return map;
        }

        @Override
        @NotNull
        public synchronized Binding getRootBinding(@NotNull Class<?> aClass, @NotNull Type originalType) {
            Map<Type, Binding> map = this.getBindingCacheMap();
            Binding binding = map.get(originalType);
            if (binding == null) {
                binding = XmlSerializer.createClassBinding(aClass, null, originalType);
                if (binding == null) {
                    binding = new BeanBinding(aClass);
                }
                map.put(originalType, binding);
                try {
                    binding.init(originalType, this);
                }
                catch (Error | RuntimeException e) {
                    map.remove(originalType);
                    throw e;
                }
            }
            return binding;
        }
    }

    public static abstract class XmlSerializerBase
    implements Serializer {
        @Override
        @Nullable
        public final Binding getBinding(@NotNull Class<?> aClass, @NotNull Type type) {
            return ClassUtil.isPrimitive(aClass) ? null : this.getRootBinding(aClass, type);
        }

        @Override
        @NotNull
        public final synchronized Binding getRootBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @NotNull MutableAccessor accessor) {
            Binding binding = XmlSerializerBase.createClassBinding(aClass, accessor, originalType);
            if (binding == null) {
                binding = this.getRootBinding(aClass, originalType);
            } else {
                binding.init(originalType, this);
            }
            return binding;
        }

        @Override
        @Nullable
        public final Binding getBinding(@NotNull MutableAccessor accessor) {
            Type type = accessor.getGenericType();
            Class<?> aClass = ClassUtil.typeToClass(type);
            return ClassUtil.isPrimitive(aClass) ? null : this.getRootBinding(aClass, type, accessor);
        }

        @Nullable
        protected static Binding createClassBinding(@NotNull Class<?> aClass, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
            if (aClass.isArray()) {
                if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                    assert (accessor != null);
                    return new JDOMElementBinding(accessor);
                }
                return new ArrayBinding(aClass, accessor);
            }
            if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                CollectionBean listBean;
                if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                    return new CompactCollectionBinding(accessor);
                }
                return new CollectionBinding((ParameterizedType)originalType, accessor);
            }
            if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                return new MapBinding(accessor, aClass);
            }
            if (accessor != null) {
                if (Element.class.isAssignableFrom(aClass)) {
                    return new JDOMElementBinding(accessor);
                }
                if (JDOMExternalizableStringList.class == aClass) {
                    return new CompactCollectionBinding(accessor);
                }
            }
            return null;
        }
    }
}

