/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SkipDefaultsSerializationFilter
extends SkipDefaultValuesSerializationFilters {
    @TestOnly
    @ApiStatus.Internal
    public SkipDefaultsSerializationFilter() {
    }

    public SkipDefaultsSerializationFilter(Object ... defaultBeans) {
        super(defaultBeans);
    }

    protected boolean equal(@NotNull NestedBinding binding, @NotNull Object bean) {
        MutableAccessor accessor = binding.getAccessor();
        return this.equal(binding, accessor.read(bean), accessor.read(this.getDefaultBean(bean)));
    }

    boolean equal(@Nullable Binding binding, @Nullable Object currentValue, @Nullable Object defaultValue) {
        Binding referencedBinding;
        if (defaultValue instanceof Element && currentValue instanceof Element) {
            return JDOMUtil.areElementsEqual((Element)currentValue, (Element)defaultValue);
        }
        if (currentValue == defaultValue) {
            return true;
        }
        if (currentValue == null || defaultValue == null) {
            return false;
        }
        if (binding instanceof BasePrimitiveBinding && (referencedBinding = ((BasePrimitiveBinding)binding).binding) instanceof BeanBinding) {
            BeanBinding classBinding = (BeanBinding)referencedBinding;
            ThreeState compareByFields = classBinding.compareByFields;
            if (compareByFields == ThreeState.UNSURE) {
                classBinding.compareByFields = compareByFields = ReflectionUtil.getDeclaredMethod(classBinding.myBeanClass, "equals", Object.class) == null ? ThreeState.YES : ThreeState.NO;
            }
            if (compareByFields == ThreeState.YES) {
                return classBinding.equalByFields(currentValue, defaultValue, this);
            }
        }
        return Comparing.equal((Object)currentValue, (Object)defaultValue);
    }
}

