/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
            String tagName = optionTag.tag();
            if ((this.myNameAttribute == null || this.myNameAttribute.isEmpty()) && "option".equals(tagName)) {
                tagName = this.accessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter) {
        Object value = this.accessor.read(o);
        Element targetElement = new Element(this.myTagName);
        if (this.myNameAttribute != null && !this.myNameAttribute.isEmpty()) {
            targetElement.setAttribute(this.myNameAttribute, this.name);
        }
        if (value == null) {
            return targetElement;
        }
        Converter<Object> converter = this.getConverter();
        if (converter == null) {
            if (this.binding == null) {
                targetElement.setAttribute(this.myValueAttribute, JDOMUtil.removeControlChars(XmlSerializerImpl.convertToString(value)));
            } else if (this.binding instanceof BeanBinding && this.myValueAttribute.isEmpty()) {
                ((BeanBinding)this.binding).serializeInto(value, targetElement, filter);
            } else {
                Object node = this.binding.serialize(value, targetElement, filter);
                if (node != null && targetElement != node) {
                    Binding.addContent(targetElement, node);
                }
            }
        } else {
            String text = converter.toString(value);
            if (text != null) {
                targetElement.setAttribute(this.myValueAttribute, JDOMUtil.removeControlChars(text));
            }
        }
        return targetElement;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        Attribute valueAttribute = element.getAttribute(this.myValueAttribute);
        if (valueAttribute == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.binding != null);
                this.accessor.set(context, this.binding.deserializeUnsafe(context, element));
            } else {
                List<Element> children2 = element.getChildren();
                if (children2.isEmpty()) {
                    if (this.binding instanceof CollectionBinding || this.binding instanceof MapBinding) {
                        Object newValue;
                        Object oldValue = this.accessor.read(context);
                        if (oldValue != null && oldValue != (newValue = ((MultiNodeBinding)this.binding).deserializeList(oldValue, children2))) {
                            this.accessor.set(context, newValue);
                        }
                    } else {
                        this.accessor.set(context, null);
                    }
                } else {
                    Object newValue;
                    assert (this.binding != null);
                    Object oldValue = this.accessor.read(context);
                    if (oldValue != (newValue = Binding.deserializeList(this.binding, oldValue, children2))) {
                        this.accessor.set(context, newValue);
                    }
                }
            }
        } else {
            String value = valueAttribute.getValue();
            if (this.converter == null) {
                try {
                    XmlSerializerImpl.doSet(context, value, this.accessor, ClassUtil.typeToClass(this.accessor.getGenericType()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot set value for field " + this.name, e);
                }
            } else {
                this.accessor.set(context, this.converter.fromString(value));
            }
        }
        return context;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull XmlElement element) {
        String value = element.getAttributeValue(this.myValueAttribute);
        if (value == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.binding != null);
                this.accessor.set(context, this.binding.deserializeUnsafe(context, element));
            } else {
                List<XmlElement> children2 = element.children;
                if (children2.isEmpty()) {
                    if (this.binding instanceof CollectionBinding || this.binding instanceof MapBinding) {
                        Object newValue;
                        Object oldValue = this.accessor.read(context);
                        if (oldValue != null && oldValue != (newValue = ((MultiNodeBinding)this.binding).deserializeList2(oldValue, children2))) {
                            this.accessor.set(context, newValue);
                        }
                    } else {
                        this.accessor.set(context, null);
                    }
                } else {
                    Object newValue;
                    assert (this.binding != null);
                    Object oldValue = this.accessor.read(context);
                    if (oldValue != (newValue = Binding.deserializeList2(this.binding, oldValue, children2))) {
                        this.accessor.set(context, newValue);
                    }
                }
            }
        } else if (this.converter == null) {
            try {
                XmlSerializerImpl.doSet(context, value, this.accessor, ClassUtil.typeToClass(this.accessor.getGenericType()));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set value for field " + this.name, e);
            }
        } else {
            this.accessor.set(context, this.converter.fromString(value));
        }
        return context;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (!element.getName().equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (this.myNameAttribute == null || this.myNameAttribute.isEmpty()) {
            return name == null || name.equals(this.name);
        }
        return name != null && name.equals(this.name);
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        if (!element.name.equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (this.myNameAttribute.isEmpty()) {
            return name == null || name.equals(this.name);
        }
        return name != null && name.equals(this.name);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.name + ", binding=" + this.binding + "]";
    }
}

