/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.dom;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0087\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JE\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0018\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/xml/dom/XmlElement;", "", "name", "", "attributes", "", "children", "", "content", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/lang/String;)V", "Lkotlin/sequences/Sequence;", "component1", "component2", "component3", "component4", "copy", "count", "", "equals", "", "other", "getAttributeValue", "defaultValue", "getChild", "hashCode", "toString", "intellij.platform.util.xmlDom"})
@ApiStatus.Internal
public final class XmlElement {
    @JvmField
    @NotNull
    public final String name;
    @JvmField
    @NotNull
    public final Map<String, String> attributes;
    @JvmField
    @NotNull
    public final List<XmlElement> children;
    @JvmField
    @Nullable
    public final String content;

    public XmlElement(@NotNull String name, @NotNull Map<String, String> attributes, @NotNull List<XmlElement> children2, @Nullable String content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        this.name = name;
        this.attributes = attributes;
        this.children = children2;
        this.content = content;
    }

    public final int count(@NotNull String name) {
        int n;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$count$iv = this.children;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                XmlElement it = (XmlElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @Nullable
    public final String getAttributeValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.attributes.get(name);
    }

    @Nullable
    public final String getAttributeValue(@NotNull String name, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = this.attributes.get(name);
        if (string2 == null) {
            string2 = defaultValue;
        }
        return string2;
    }

    @Nullable
    public final XmlElement getChild(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.children;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XmlElement it = (XmlElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Sequence<XmlElement> children(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.children), (Function1)((Function1)new Function1<XmlElement, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull XmlElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.name, (Object)this.$name);
            }
        }));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.attributes;
    }

    @NotNull
    public final List<XmlElement> component3() {
        return this.children;
    }

    @Nullable
    public final String component4() {
        return this.content;
    }

    @NotNull
    public final XmlElement copy(@NotNull String name, @NotNull Map<String, String> attributes, @NotNull List<XmlElement> children2, @Nullable String content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        return new XmlElement(name, attributes, children2, content);
    }

    public static /* synthetic */ XmlElement copy$default(XmlElement xmlElement, String string2, Map map, List list, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = xmlElement.name;
        }
        if ((n & 2) != 0) {
            map = xmlElement.attributes;
        }
        if ((n & 4) != 0) {
            list = xmlElement.children;
        }
        if ((n & 8) != 0) {
            string3 = xmlElement.content;
        }
        return xmlElement.copy(string2, map, list, string3);
    }

    @NotNull
    public String toString() {
        return "XmlElement(name=" + this.name + ", attributes=" + this.attributes + ", children=" + this.children + ", content=" + this.content + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.attributes).hashCode();
        result = result * 31 + ((Object)this.children).hashCode();
        result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XmlElement)) {
            return false;
        }
        XmlElement xmlElement = (XmlElement)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)xmlElement.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attributes, xmlElement.attributes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.children, xmlElement.children)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.content, (Object)xmlElement.content);
    }
}

