/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    @Deprecated
    public final boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result = ourInstance.get();
        if (result == null && !ourInstance.compareAndSet(null, result = new SwingEdtInvocationManager())) {
            result = ourInstance.get();
        }
        return result;
    }

    @Nullable
    public static EdtInvocationManager setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        return ourInstance.getAndSet(edtInvocationManager);
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            try {
                EdtInvocationManager.getInstance().invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance(EdtInvocationManager.class).error(e);
            }
        }
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public void invokeLater(@NotNull Runnable task) {
            EventQueue.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            EventQueue.invokeAndWait(task);
        }
    }
}

