/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class EDT {
    private static Thread myEventDispatchThread;
    private static MethodHandle dispatchEventMethod;

    private EDT() {
    }

    @ApiStatus.Internal
    public static void updateEdt() {
        if (myEventDispatchThread != Thread.currentThread()) {
            myEventDispatchThread = Thread.currentThread();
        }
    }

    @ApiStatus.Internal
    public static boolean isEdt(@NotNull Thread thread) {
        return thread == myEventDispatchThread;
    }

    @ApiStatus.Internal
    @NotNull
    public static Thread getEventDispatchThread() {
        return myEventDispatchThread;
    }

    public static boolean isCurrentThreadEdt() {
        return myEventDispatchThread == null ? EventQueue.isDispatchThread() : EDT.isEdt(Thread.currentThread());
    }

    public static void assertIsEdt() {
        if (!EDT.isCurrentThreadEdt()) {
            Logger.getInstance(EDT.class).error("Assert: must be called on EDT");
        }
    }

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        EDT.assertIsEdt();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        MethodHandle dispatchEventMethod = EDT.dispatchEventMethod;
        if (dispatchEventMethod == null) {
            try {
                Method method = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method.setAccessible(true);
                dispatchEventMethod = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException();
            }
            EDT.dispatchEventMethod = dispatchEventMethod;
        }
        boolean threadsDumped = false;
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.bindTo(eventQueue).invoke(event);
                }
            }
            catch (Throwable e) {
                ExceptionUtilRt.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
                if (!threadsDumped) {
                    threadsDumped = true;
                    try {
                        Object application = ReflectionUtil.getMethod(Class.forName("com.intellij.openapi.application.ApplicationManager"), "getApplication", new Class[0]).invoke(null, new Object[0]);
                        System.err.println("Application=" + application + "\n" + ThreadDumper.dumpThreadsToString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++i;
        }
    }
}

