/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NameUtilCore {
    public static String @NotNull [] splitNameIntoWords(@NotNull String name) {
        String[] underlineDelimited = name.split("_");
        ArrayList result = new ArrayList();
        for (String word : underlineDelimited) {
            NameUtilCore.addAllWords(word, result);
        }
        return ArrayUtilRt.toStringArray(result);
    }

    private static void addAllWords(@NotNull String text, @NotNull List<? super String> result) {
        int start = 0;
        while (start < text.length()) {
            int next = NameUtilCore.nextWord(text, start);
            result.add(text.substring(start, next));
            start = next;
        }
    }

    public static int nextWord(@NotNull String text, int start) {
        int i;
        if (!Character.isLetterOrDigit(text.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text.length() && Character.isDigit(text.charAt(i)); ++i) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && Character.isUpperCase(text.charAt(i))) {
            ++i;
        }
        if (i > start + 1) {
            if (i == text.length() || !Character.isLetter(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start) {
            ++i;
        }
        while (i < text.length() && Character.isLetter(text.charAt(i)) && !NameUtilCore.isWordStart(text, i)) {
            ++i;
        }
        return i;
    }

    public static boolean isWordStart(String text, int i) {
        char c = text.charAt(i);
        if (Character.isUpperCase(c)) {
            if (i > 0 && Character.isUpperCase(text.charAt(i - 1))) {
                return i + 1 < text.length() && Character.isLowerCase(text.charAt(i + 1));
            }
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (!Character.isLetter(c)) {
            return false;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1)) || NameUtilCore.isHardCodedWordStart(text, i);
    }

    private static boolean isHardCodedWordStart(String text, int i) {
        return text.charAt(i) == 'l' && i < text.length() - 1 && text.charAt(i + 1) == 'n' && (text.length() == i + 2 || NameUtilCore.isWordStart(text, i + 2));
    }

    public static String @NotNull [] nameToWords(@NotNull String name) {
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            String word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (StringUtilRt.isEmptyOrSpaces((CharSequence)(word = name.substring(wordStart, index)))) continue;
            array.add(word);
        }
        return ArrayUtilRt.toStringArray(array);
    }
}

