/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableCharSequence
implements CharSequence {
    @Contract(pure=true)
    public static CharSequence asImmutable(@NotNull CharSequence cs) {
        return ImmutableCharSequence.isImmutable(cs) ? cs : cs.toString();
    }

    private static boolean isImmutable(@NotNull CharSequence cs) {
        return cs instanceof ImmutableCharSequence || cs instanceof CharSequenceSubSequence && ImmutableCharSequence.isImmutable(((CharSequenceSubSequence)cs).getBaseSequence());
    }

    @Contract(pure=true)
    public abstract ImmutableCharSequence concat(@NotNull CharSequence var1);

    @Contract(pure=true)
    public abstract ImmutableCharSequence insert(int var1, @NotNull CharSequence var2);

    @Contract(pure=true)
    public abstract ImmutableCharSequence delete(int var1, int var2);

    @Contract(pure=true)
    public abstract ImmutableCharSequence subtext(int var1, int var2);

    @Contract(pure=true)
    public ImmutableCharSequence replace(int start, int end, @NotNull CharSequence seq) {
        return this.delete(start, end).insert(start, seq);
    }

    @Override
    @NotNull
    public abstract String toString();
}

