/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import org.jetbrains.annotations.NotNull;

public final class EditDistance {
    private EditDistance() {
    }

    public static int levenshtein(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive) {
        int[][] d = EditDistance.prepare(str1.length(), str2.length());
        for (int i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int cost = EditDistance.equal(str1.charAt(i - 1), str2.charAt(j - 1), caseSensitive) ? 0 : 1;
                d[i][j] = EditDistance.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[str1.length()][str2.length()];
    }

    public static int optimalAlignment(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive) {
        return EditDistance.optimalAlignment(str1, str2, caseSensitive, Integer.MAX_VALUE);
    }

    public static int optimalAlignment(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive, int limit) {
        if (str1.length() > str2.length()) {
            CharSequence tmp = str1;
            str1 = str2;
            str2 = tmp;
        }
        int length1 = str1.length();
        int length2 = str2.length();
        if (length1 == 0) {
            return length2;
        }
        if (length2 == 0) {
            return length1;
        }
        int[] v0 = new int[length1 + 1];
        int[] v1 = new int[length1 + 1];
        int[] v2 = new int[length1 + 1];
        for (int i = 1; i <= length1; ++i) {
            v1[i] = i;
        }
        int minCost = limit + 1;
        for (int j = 0; j < length2; ++j) {
            v2[0] = j + 1;
            for (int i = 0; i < length1; ++i) {
                int currentCost;
                int cost = EditDistance.equal(str1.charAt(i), str2.charAt(j), caseSensitive) ? 0 : 1;
                v2[i + 1] = EditDistance.min(v2[i] + 1, v1[i + 1] + 1, v1[i] + cost);
                if (i > 0 && j > 0 && EditDistance.equal(str2.charAt(j), str1.charAt(i - 1), caseSensitive) && EditDistance.equal(str1.charAt(i), str2.charAt(j - 1), caseSensitive)) {
                    v2[i + 1] = Math.min(v2[i + 1], v0[i - 1] + cost);
                }
                if ((currentCost = v2[i + 1]) >= minCost) continue;
                minCost = currentCost;
            }
            if (minCost > limit) {
                return minCost;
            }
            minCost = limit + 1;
            int[] temp = v0;
            v0 = v1;
            v1 = v2;
            v2 = temp;
        }
        return v1[length1];
    }

    private static int[][] prepare(int length1, int length2) {
        int[][] d = new int[length1 + 1][length2 + 1];
        for (int i = 0; i <= length1; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= length2; ++j) {
            d[0][j] = j;
        }
        return d;
    }

    private static boolean equal(char c1, char c2, boolean caseSensitive) {
        return caseSensitive ? c1 == c2 : Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }
}

