/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CharSequenceSubSequence
implements CharSequence,
CharArrayExternalizable,
CharSequenceWithStringHash {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence chars) {
        this(chars, 0, chars.length());
    }

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start, int end) {
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars.charAt(index + this.myStart);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            return this;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myChars instanceof String) {
            return ((String)this.myChars).substring(this.myStart, this.myEnd);
        }
        return new String(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
    }

    @NotNull
    CharSequence getBaseSequence() {
        return this.myChars;
    }

    @Override
    public void getChars(int start, int end, char @NotNull [] dest, int destPos) {
        assert (end - start <= this.myEnd - this.myStart);
        CharArrayUtil.getChars(this.myChars, dest, start + this.myStart, destPos, end - start);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this.myChars, this.myStart, this.myEnd);
        }
        return h;
    }
}

