/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MethodHandleCache {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ClassValue<ConcurrentMap<Method, MethodHandle>> CACHE = new ConcurrentMapClassValue();

    MethodHandleCache() {
    }

    @NotNull
    static MethodHandle compute(@NotNull Method method, Object @Nullable [] args2) {
        return CACHE.get(method.getDeclaringClass()).computeIfAbsent(method, method1 -> {
            MethodHandle result;
            method1.setAccessible(true);
            try {
                result = LOOKUP.unreflect((Method)method1);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return args2 == null ? result : result.asSpreader(Object[].class, args2.length);
        });
    }

    private static final class ConcurrentMapClassValue
    extends ClassValue<ConcurrentMap<Method, MethodHandle>> {
        private ConcurrentMapClassValue() {
        }

        @Override
        protected ConcurrentMap<Method, MethodHandle> computeValue(@NotNull Class<?> type) {
            return new ConcurrentHashMap<Method, MethodHandle>(8);
        }
    }
}

