/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ImmutableZipEntry;
import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.ZipFile;
import com.intellij.util.lang.ZipFilePool;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ZipResourceFile
implements ResourceFile {
    private final ZipFile zipFile;
    private final boolean defineClassUsingBytes;

    ZipResourceFile(@NotNull Path file2, boolean defineClassUsingBytes) {
        this.defineClassUsingBytes = defineClassUsingBytes;
        ZipFilePool pool = ZipFilePool.POOL;
        try {
            if (pool == null) {
                this.zipFile = ImmutableZipFile.load(file2);
            } else {
                Object zipFile = pool.loadZipFile(file2);
                this.zipFile = (ZipFile)zipFile;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> nameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        this.zipFile.processResources(dir, nameFilter, consumer);
    }

    @Override
    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        try (InputStream stream = this.zipFile.getInputStream("META-INF/MANIFEST.MF");){
            if (stream == null) {
                Attributes attributes = null;
                return attributes;
            }
            Attributes attributes = new Manifest(stream).getMainAttributes();
            return attributes;
        }
    }

    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() {
        if (this.zipFile instanceof ImmutableZipFile) {
            final ImmutableZipFile file2 = (ImmutableZipFile)this.zipFile;
            return new ClasspathCache.IndexRegistrar(){

                @Override
                public int classPackageCount() {
                    return file2.classPackages.length;
                }

                @Override
                public int resourcePackageCount() {
                    return file2.resourcePackages.length;
                }

                @Override
                public long[] classPackages() {
                    return file2.classPackages;
                }

                @Override
                public long[] resourcePackages() {
                    return file2.resourcePackages;
                }
            };
        }
        return this.computePackageIndex();
    }

    @NotNull
    private ClasspathCache.LoaderDataBuilder computePackageIndex() {
        ClasspathCache.LoaderDataBuilder builder = new ClasspathCache.LoaderDataBuilder();
        for (ImmutableZipEntry entry : ((HashMapZipFile)this.zipFile).getRawNameSet()) {
            if (entry == null) continue;
            builder.addPackageFromName(entry.name);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> findClass(String fileName, String className, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        if (!this.defineClassUsingBytes && classConsumer.isByteBufferSupported(className)) {
            ByteBuffer buffer = this.zipFile.getByteBuffer(fileName);
            if (buffer == null) {
                return null;
            }
            try {
                Class<?> clazz = classConsumer.consumeClassData(className, buffer, (Loader)jarLoader);
                return clazz;
            }
            finally {
                this.zipFile.releaseBuffer(buffer);
            }
        }
        byte[] data = this.zipFile.getData(fileName);
        if (data == null) {
            return null;
        }
        return classConsumer.consumeClassData(className, data, (Loader)jarLoader);
    }

    @Override
    @Nullable
    public Resource getResource(@NotNull String name, @NotNull JarLoader jarLoader) {
        ZipFile.ZipResource entry = this.zipFile.getResource(name);
        return entry == null ? null : new ZipFileResource(jarLoader, entry, name);
    }

    private static final class ZipFileResource
    implements Resource {
        private final JarLoader jarLoader;
        private URL url;
        private final String name;
        private final ZipFile.ZipResource entry;

        private ZipFileResource(@NotNull JarLoader jarLoader, @NotNull ZipFile.ZipResource entry, @NotNull String name) {
            this.jarLoader = jarLoader;
            this.entry = entry;
            this.name = name;
        }

        public String toString() {
            return "ZipFileResource(name=" + this.entry + ")";
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result = this.url;
            if (result == null) {
                MyJarUrlStreamHandler handler = new MyJarUrlStreamHandler(this.entry, this.jarLoader);
                try {
                    result = new URL(this.jarLoader.url, this.name, handler);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result;
                handler.original = result;
            }
            return result;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return this.entry.getInputStream();
        }

        @Override
        public byte @NotNull [] getBytes() throws IOException {
            return this.entry.getData();
        }
    }

    private static final class MyJarUrlConnection
    extends JarURLConnection {
        private ZipFile.ZipResource effectiveEntry;
        private final JarLoader jarLoader;
        private byte[] data;

        MyJarUrlConnection(@NotNull URL url, @NotNull ZipFile.ZipResource entry, @NotNull JarLoader jarLoader) throws MalformedURLException {
            super(url);
            String entryName = this.getEntryName();
            this.effectiveEntry = entryName == null || entryName.equals(entry.getPath()) ? entry : null;
            this.jarLoader = jarLoader;
        }

        private byte[] getData() throws IOException {
            byte[] result = this.data;
            if (result == null) {
                this.connect();
                this.data = result = this.effectiveEntry.getData();
            }
            return result;
        }

        @Override
        public void connect() throws IOException {
            if (this.effectiveEntry == null) {
                Resource resource = this.jarLoader.zipFile.getResource(this.getEntryName(), this.jarLoader);
                if (resource == null) {
                    throw new NoSuchFileException("Cannot find `" + this.getEntryName() + "` in " + this.jarLoader.getPath());
                }
                this.effectiveEntry = ((ZipFileResource)resource).entry;
            }
        }

        @Override
        public Object getContent() throws IOException {
            return this.getData();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.effectiveEntry.getInputStream();
        }

        @Override
        public long getContentLengthLong() {
            return this.getContentLength();
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
            }
            catch (IOException e) {
                return -1;
            }
            return this.effectiveEntry.getUncompressedSize();
        }

        @Override
        public JarFile getJarFile() throws IOException {
            System.out.println("Do not use URL connection as JarURLConnection");
            return new JarFile(this.jarLoader.getPath().toFile());
        }
    }

    private static final class MyUrlConnection
    extends URLConnection {
        private ZipFile.ZipResource entry;
        private final JarLoader jarLoader;
        private byte[] data;

        MyUrlConnection(@NotNull URL url, @Nullable ZipFile.ZipResource entry, @NotNull JarLoader jarLoader) {
            super(url);
            this.entry = entry;
            this.jarLoader = jarLoader;
        }

        private byte[] getData() throws IOException {
            byte[] result = this.data;
            if (result == null) {
                this.data = result = this.getEntry().getData();
            }
            return result;
        }

        private ZipFile.ZipResource getEntry() throws IOException {
            ZipFile.ZipResource result = this.entry;
            if (result == null) {
                Resource resource;
                String spec = this.url.getFile();
                int index = spec.indexOf("!/");
                if (index != -1) {
                    index += 2;
                }
                String entryName = index != -1 && index != spec.length() ? spec.substring(index) : null;
                Resource resource2 = resource = entryName == null ? null : this.jarLoader.zipFile.getResource(entryName, this.jarLoader);
                if (resource == null) {
                    throw new NoSuchFileException("Cannot find `" + spec + "` in " + this.jarLoader.getPath());
                }
                this.entry = result = ((ZipFileResource)resource).entry;
            }
            return result;
        }

        @Override
        public void connect() {
        }

        @Override
        public Object getContent() throws IOException {
            return this.getData();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.getEntry().getInputStream();
        }

        @Override
        public int getContentLength() {
            try {
                return this.getEntry().getUncompressedSize();
            }
            catch (IOException e) {
                return -1;
            }
        }
    }

    private static final class MyJarUrlStreamHandler
    extends URLStreamHandler {
        @NotNull
        private final ZipFile.ZipResource entry;
        @NotNull
        private final JarLoader jarLoader;
        private URL original;

        private MyJarUrlStreamHandler(@NotNull ZipFile.ZipResource entry, @NotNull JarLoader jarLoader) {
            this.entry = entry;
            this.jarLoader = jarLoader;
        }

        @Override
        protected URLConnection openConnection(URL url) throws MalformedURLException {
            if (this.jarLoader.configuration.mimicJarUrlConnection) {
                return new MyJarUrlConnection(url, this.entry, this.jarLoader);
            }
            return new MyUrlConnection(url, url == this.original || url.equals(this.original) ? this.entry : null, this.jarLoader);
        }
    }
}

