/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.UrlUtilRt;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassLoadingLocks;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader
implements ClassPath.ClassDataConsumer {
    private static final boolean isClassPathIndexEnabledGlobalValue = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    private static final boolean mimicJarUrlConnection = Boolean.parseBoolean(System.getProperty("idea.mimic.jar.url.connection", "false"));
    private static final boolean isParallelCapable = UrlClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = UrlClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> skipFindingResource = new ThreadLocal();
    private final List<Path> files;
    protected final ClassPath classPath;
    private final ClassLoadingLocks<String> classLoadingLocks;
    private final boolean isBootstrapResourcesAllowed;
    private final boolean isSystemClassLoader;
    @NotNull
    protected final ClassPath.ClassDataConsumer classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
    @ApiStatus.Internal
    @Nullable
    public BiFunction<String, Boolean, String> resolveScopeManager;

    final void appendToClassPathForInstrumentation(@NotNull String jar) {
        this.addFiles(Collections.singletonList(Paths.get(jar, new String[0])));
    }

    @ApiStatus.Internal
    @NotNull
    public final ClassPath getClassPath() {
        return this.classPath;
    }

    @NotNull
    public final List<Path> getBaseUrls() {
        return this.classPath.getBaseUrls();
    }

    @NotNull
    public final Map<String, Long> getLoadingStats() {
        return ClassPath.getLoadingStats();
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent) {
        this(UrlClassLoader.createDefaultBuilderForJdk(parent), null, isParallelCapable);
        UrlClassLoader.registerInClassLoaderValueMap(parent, this);
    }

    protected static void registerInClassLoaderValueMap(@NotNull ClassLoader parent, @NotNull ClassLoader classLoader) {
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(classLoader, f.get(parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    protected static Builder createDefaultBuilderForJdk(@NotNull ClassLoader parent) {
        Builder configuration = new Builder();
        if (parent instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)parent).getURLs();
            configuration.files = new ArrayList<Path>(urls.length);
            for (URL url : urls) {
                configuration.files.add(Paths.get(url.getPath(), new String[0]));
            }
        } else {
            String[] parts = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
            configuration.files = new ArrayList<Path>(parts.length);
            for (String s : parts) {
                configuration.files.add(Paths.get(s, new String[0]));
            }
        }
        configuration.isSystemClassLoader = true;
        configuration.parent = parent.getParent();
        configuration.useCache = true;
        configuration.isClassPathIndexEnabled = isClassPathIndexEnabledGlobalValue;
        configuration.isBootstrapResourcesAllowed = Boolean.parseBoolean(System.getProperty("idea.allow.bootstrap.resources", "true"));
        return configuration;
    }

    protected UrlClassLoader(@NotNull Builder builder, boolean isParallelCapable) {
        this(builder, null, isParallelCapable);
    }

    protected UrlClassLoader(@NotNull Builder builder, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean isParallelCapable) {
        super(builder.parent);
        this.isSystemClassLoader = builder.isSystemClassLoader;
        this.files = builder.files;
        this.classPath = new ClassPath(this.files, builder, resourceFileFactory, mimicJarUrlConnection);
        this.isBootstrapResourcesAllowed = builder.isBootstrapResourcesAllowed;
        this.classLoadingLocks = isParallelCapable ? new ClassLoadingLocks() : null;
    }

    protected UrlClassLoader(@NotNull List<Path> files2, @NotNull ClassPath classPath) {
        super(null);
        this.files = files2;
        this.classPath = classPath;
        this.isBootstrapResourcesAllowed = false;
        this.isSystemClassLoader = false;
        this.classLoadingLocks = new ClassLoadingLocks();
    }

    @Deprecated
    public final void addURL(@NotNull URL url) {
        this.addFiles(Collections.singletonList(Paths.get(url.getPath(), new String[0])));
    }

    @ApiStatus.Internal
    public final void addFiles(@NotNull List<Path> files2) {
        this.classPath.addFiles(files2);
        this.files.addAll(files2);
    }

    @NotNull
    public final List<URL> getUrls() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Path file2 : this.files) {
            try {
                result.add(file2.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }

    @NotNull
    public final List<Path> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass = this.findLoadedClass(name);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        String fileNameWithoutExtension = name.replace('.', '/');
        String fileName = fileNameWithoutExtension + ".class";
        long packageNameHash = ClasspathCache.getPackageNameHash(fileNameWithoutExtension, fileNameWithoutExtension.lastIndexOf(47));
        if (this.isSystemClassLoader && (packageNameHash == -9217824570049207139L || packageNameHash == -1976620678582843062L || packageNameHash == 4571982292824530778L)) {
            return appClassLoader.loadClass(name);
        }
        try {
            clazz = this.classPath.findClass(name, fileName, packageNameHash, this.classDataConsumer);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    private void definePackageIfNeeded(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName = name.substring(0, lastDotIndex);
        if (this.isPackageDefined(packageName)) {
            return;
        }
        try {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isPackageDefined(String packageName) {
        return this.getPackage(packageName) != null;
    }

    @Override
    public boolean isByteBufferSupported(@NotNull String name) {
        return true;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name, byte[] data, Loader loader) throws IOException {
        this.definePackageIfNeeded(name);
        return super.defineClass(name, data, 0, data.length, null);
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name, ByteBuffer data, Loader loader) {
        this.definePackageIfNeeded(name);
        return super.defineClass(name, data, null);
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name) {
        if (skipFindingResource.get() != null) {
            return null;
        }
        Resource resource = this.doFindResource(name);
        return resource != null ? resource.getURL() : null;
    }

    public byte @Nullable [] getResourceAsBytes(@NotNull String name, boolean checkParents) throws IOException {
        Resource resource = this.classPath.findResource(name);
        return resource == null ? null : resource.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name) {
        Resource resource = this.doFindResource(name);
        if (resource != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                this.logError("Cannot load resource " + name, e);
                return null;
            }
        }
        if (this.isBootstrapResourcesAllowed) {
            skipFindingResource.set(Boolean.TRUE);
            try {
                URL url = super.getResource(name);
                if (url != null) {
                    try {
                        InputStream inputStream = url.openStream();
                        return inputStream;
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                skipFindingResource.set(null);
            }
        }
        return null;
    }

    @Nullable
    private Resource doFindResource(String name) {
        String canonicalPath = UrlClassLoader.toCanonicalPath(name);
        Resource resource = this.classPath.findResource(canonicalPath);
        if (resource == null && canonicalPath.startsWith("/") && this.classPath.findResource(canonicalPath.substring(1)) != null) {
            this.logError("Calling `ClassLoader#getResource` with leading slash doesn't work; strip", new IllegalArgumentException(name));
        }
        return resource;
    }

    public final void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        this.classPath.processResources(dir, fileNameFilter, consumer);
    }

    @Override
    @NotNull
    public Enumeration<URL> findResources(@NotNull String name) throws IOException {
        return this.classPath.getResources(name);
    }

    @Override
    @NotNull
    protected final Object getClassLoadingLock(String className) {
        return this.classLoadingLocks == null ? this : this.classLoadingLocks.getOrCreateLock(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> loadClassInsideSelf(String name, String fileName, long packageNameHash, boolean forceLoadFromSubPluginClassloader) throws IOException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (!forceLoadFromSubPluginClassloader) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    try {
                        c = parent.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c != null) {
                    return c;
                }
            }
            return this.classPath.findClass(name, fileName, packageNameHash, this.classDataConsumer);
        }
    }

    @NotNull
    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    protected static String toCanonicalPath(@NotNull String path) {
        char next;
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/') {
                path = path.substring(2);
            }
        }
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            return path;
        }
        StringBuilder result = new StringBuilder(path.length());
        int start = UrlClassLoader.processRoot(path, result);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    UrlClassLoader.processDots(result, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result.append('.');
                --dots;
            }
            result.append(c);
            separator = false;
        }
        if (dots > 0) {
            UrlClassLoader.processDots(result, dots, start);
        }
        return result.toString();
    }

    private static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    private static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static void processDots(StringBuilder result, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!UrlClassLoader.endsWith(result, "/../") && !"../".contentEquals(result)) {
                pos = UrlClassLoader.lastIndexOf(result, '/', start, result.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result.delete(pos, result.length());
            } else {
                result.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result.append('.');
            }
            result.append('/');
        }
    }

    private static int processRoot(String path, StringBuilder result) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            result.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private void logError(String message, Throwable t) {
        try {
            Class<?> logger = this.loadClass("com.intellij.openapi.diagnostic.Logger");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object instance = lookup.findStatic(logger, "getInstance", MethodType.methodType(logger, Class.class)).invoke(this.getClass());
            lookup.findVirtual(logger, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class)).bindTo(instance).invokeExact(message, t);
        }
        catch (Throwable tt) {
            t.addSuppressed(tt);
            System.err.println(this.getClass().getName() + ": " + message);
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    public static String urlToFilePath(@NotNull String url) {
        int start = url.startsWith("file:") ? "file:".length() : 0;
        int end = url.indexOf("!/");
        if (url.charAt(start) == '/' && url.length() > start + 2 && url.charAt(start + 2) == ':') {
            ++start;
        }
        return UrlUtilRt.unescapePercentSequences(url, start, end < 0 ? url.length() : end).toString();
    }

    public static final class Builder {
        List<Path> files = Collections.emptyList();
        ClassLoader parent;
        boolean lockJars = true;
        boolean useCache = true;
        boolean isSystemClassLoader;
        boolean isClassPathIndexEnabled = UrlClassLoader.access$000();
        boolean isBootstrapResourcesAllowed;
        @Nullable
        CachePoolImpl cachePool;
        Predicate<? super Path> cachingCondition;

        Builder() {
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            ArrayList<Path> files2 = new ArrayList<Path>(urls.size());
            for (URL url : urls) {
                files2.add(Paths.get(UrlClassLoader.urlToFilePath(url.getPath()), new String[0]));
            }
            this.files = files2;
            return this;
        }

        @NotNull
        public Builder files(@NotNull List<Path> paths) {
            this.files = paths;
            return this;
        }

        @NotNull
        public Builder parent(ClassLoader parent) {
            this.parent = parent;
            return this;
        }

        @NotNull
        public Builder allowLock(boolean lockJars) {
            this.lockJars = lockJars;
            return this;
        }

        @NotNull
        public Builder useCache() {
            this.useCache = true;
            return this;
        }

        @NotNull
        public Builder useCache(boolean useCache) {
            this.useCache = useCache;
            return this;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories(boolean value) {
            this.isClassPathIndexEnabled = value;
            return this;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.isClassPathIndexEnabled = isClassPathIndexEnabledGlobalValue;
            return this;
        }

        @NotNull
        public Builder useCache(@NotNull CachePool pool, @NotNull Predicate<? super Path> condition) {
            this.useCache = true;
            this.cachePool = (CachePoolImpl)pool;
            this.cachingCondition = condition;
            return this;
        }

        @NotNull
        public Builder noPreload() {
            return this;
        }

        @NotNull
        public Builder allowBootstrapResources() {
            return this.allowBootstrapResources(true);
        }

        @NotNull
        public Builder allowBootstrapResources(boolean allowBootstrapResources) {
            this.isBootstrapResourcesAllowed = allowBootstrapResources;
            return this;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this, null, isParallelCapable);
        }
    }

    public static interface CachePool {
    }
}

