/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Loader;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipResourceFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PathClassLoader
extends UrlClassLoader {
    static final Function<Path, ResourceFile> RESOURCE_FILE_FACTORY;
    private static final boolean isParallelCapable;
    private BytecodeTransformer transformer;

    public PathClassLoader(@NotNull UrlClassLoader.Builder builder) {
        super(builder, RESOURCE_FILE_FACTORY, isParallelCapable);
    }

    public static Function<Path, ResourceFile> getResourceFileFactory() {
        return RESOURCE_FILE_FACTORY;
    }

    public void setTransformer(BytecodeTransformer transformer) {
        assert (this.transformer == null);
        this.transformer = transformer;
    }

    public PathClassLoader(@NotNull ClassLoader parent) {
        super(UrlClassLoader.createDefaultBuilderForJdk(parent), RESOURCE_FILE_FACTORY, isParallelCapable);
        this.transformer = null;
        UrlClassLoader.registerInClassLoaderValueMap(parent, this);
    }

    @Override
    public boolean isByteBufferSupported(@NotNull String name) {
        return this.transformer == null || !this.transformer.isApplicable(name, this);
    }

    @Override
    protected boolean isPackageDefined(String packageName) {
        return this.getDefinedPackage(packageName) != null;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name, byte[] data, Loader loader) throws IOException {
        byte[] transformedData;
        BytecodeTransformer transformer = this.transformer;
        if (transformer != null && transformer.isApplicable(name, this) && (transformedData = transformer.transform(this, name, data)) != null) {
            return super.consumeClassData(name, transformedData, loader);
        }
        return super.consumeClassData(name, data, loader);
    }

    static {
        boolean defineClassUsingBytes = Boolean.parseBoolean(System.getProperty("idea.define.class.using.byte.array", "false"));
        RESOURCE_FILE_FACTORY = !defineClassUsingBytes && System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows") ? file2 -> {
            String path = file2.toString();
            return new ZipResourceFile((Path)file2, path.length() > 2 && path.charAt(0) == '\\' && path.charAt(1) == '\\');
        } : file2 -> new ZipResourceFile((Path)file2, defineClassUsingBytes);
        isParallelCapable = ClassLoader.registerAsParallelCapable();
    }

    public static interface BytecodeTransformer {
        default public boolean isApplicable(String className, ClassLoader loader) {
            return true;
        }

        public byte[] transform(ClassLoader var1, String var2, byte[] var3);
    }
}

