/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JdkZipResourceFile
implements ResourceFile {
    private volatile SoftReference<ZipFile> zipFileSoftReference;
    private final boolean lockJars;
    private final File file;
    private static final Object lock = new Object();

    JdkZipResourceFile(@NotNull Path path, boolean lockJars) {
        this.lockJars = lockJars;
        this.file = path.toFile();
    }

    private static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    ZipFile getZipFile() throws IOException {
        ZipFile zipFile;
        if (!this.lockJars) {
            return new ZipFile(this.file);
        }
        SoftReference<ZipFile> ref = this.zipFileSoftReference;
        ZipFile zipFile2 = zipFile = ref == null ? null : ref.get();
        if (zipFile != null) {
            return zipFile;
        }
        Object object = lock;
        synchronized (object) {
            ref = this.zipFileSoftReference;
            ZipFile zipFile3 = zipFile = ref == null ? null : ref.get();
            if (zipFile != null) {
                return zipFile;
            }
            zipFile = new ZipFile(this.file);
            this.zipFileSoftReference = new SoftReference<ZipFile>(zipFile);
        }
        return zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> findClass(@NotNull String fileName, String className, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            byte[] bytes;
            ZipEntry entry = zipFile.getEntry(fileName);
            if (entry == null) {
                Class<?> clazz = null;
                return clazz;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                bytes = JdkZipResourceFile.loadBytes(stream, (int)entry.getSize());
            }
            Class<?> clazz = classConsumer.consumeClassData(className, bytes, (Loader)jarLoader);
            return clazz;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> filter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Resource getResource(@NotNull String name, @NotNull JarLoader jarLoader) throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            ZipEntry entry = zipFile.getEntry(name);
            if (entry == null) {
                Resource resource = null;
                return resource;
            }
            ZipFileResource zipFileResource = new ZipFileResource(jarLoader.url, entry, this);
            return zipFileResource;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            Attributes attributes;
            block14: {
                ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                if (entry == null) {
                    Attributes attributes2 = null;
                    return attributes2;
                }
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    attributes = new Manifest(stream).getMainAttributes();
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        Attributes attributes3 = null;
                        return attributes3;
                    }
                }
                stream.close();
            }
            return attributes;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            ClasspathCache.LoaderDataBuilder builder = new ClasspathCache.LoaderDataBuilder();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                builder.addPackageFromName(entries.nextElement().getName());
            }
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = builder;
            return loaderDataBuilder;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    private static final class ZipFileResource
    implements Resource {
        private final URL baseUrl;
        private URL url;
        private final ZipEntry entry;
        private final JdkZipResourceFile file;

        private ZipFileResource(@NotNull URL baseUrl, @NotNull ZipEntry entry, @NotNull JdkZipResourceFile file2) {
            this.baseUrl = baseUrl;
            this.entry = entry;
            this.file = file2;
        }

        public String toString() {
            return this.url.toString();
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result = this.url;
            if (result == null) {
                try {
                    result = new URL(this.baseUrl, this.entry.getName());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result;
            }
            return result;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public byte @NotNull [] getBytes() throws IOException {
            ZipFile zipFile = this.file.getZipFile();
            try {
                byte[] byArray;
                block10: {
                    InputStream stream = zipFile.getInputStream(this.entry);
                    try {
                        byArray = JdkZipResourceFile.loadBytes(stream, (int)this.entry.getSize());
                        if (stream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return byArray;
            }
            finally {
                if (!this.file.lockJars) {
                    zipFile.close();
                }
            }
        }
    }
}

