/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferPool {
    public static final DirectByteBufferPool DEFAULT_POOL = new DirectByteBufferPool(it -> {});
    private static final int MIN_SIZE = 2048;
    private static final int MAX_POOL_SIZE = 32;
    private final ConcurrentSkipListMap<Integer, ByteBuffer> pool = new ConcurrentSkipListMap();
    private final AtomicInteger count = new AtomicInteger();
    @NotNull
    private final Consumer<? super ByteBuffer> releaser;

    public DirectByteBufferPool(@NotNull Consumer<? super ByteBuffer> releaser) {
        this.releaser = releaser;
    }

    @NotNull
    public ByteBuffer allocate(int requiredSize) {
        ByteBuffer result;
        Map.Entry<Integer, ByteBuffer> entry;
        int size = DirectByteBufferPool.roundUpInt(requiredSize, 2048);
        while ((entry = this.pool.ceilingEntry(size)) != null && !this.pool.remove(entry.getKey(), entry.getValue())) {
        }
        if (entry == null) {
            result = ByteBuffer.allocateDirect(size);
        } else {
            this.count.decrementAndGet();
            result = entry.getValue();
        }
        result.limit(requiredSize);
        return result;
    }

    public void release(@NotNull ByteBuffer buffer) {
        if (buffer.isReadOnly()) {
            return;
        }
        buffer.rewind();
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (this.count.get() < 32 && this.pool.putIfAbsent(buffer.capacity(), buffer) == null) {
            this.count.incrementAndGet();
        } else {
            this.releaser.accept(buffer);
        }
    }

    public void releaseAll() {
        Iterator<ByteBuffer> iterator = this.pool.values().iterator();
        while (iterator.hasNext()) {
            ByteBuffer buffer = iterator.next();
            iterator.remove();
            this.releaser.accept(buffer);
        }
    }

    private static int roundUpInt(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }
}

