/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.ExceptionUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundRuntimeException
extends RuntimeException {
    private final List<? extends Throwable> exceptions;

    public CompoundRuntimeException(@NotNull List<? extends Throwable> throwables) {
        this.exceptions = throwables;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.exceptions.isEmpty() ? null : this.exceptions.get(0);
    }

    public List<Throwable> getExceptions() {
        return new ArrayList<Throwable>(this.exceptions);
    }

    @Override
    public String getMessage() {
        return this.processAll(Throwable::getMessage, null).toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.processAll(Throwable::getLocalizedMessage, null).toString();
    }

    @Override
    public String toString() {
        return this.processAll(Throwable::toString, null).toString();
    }

    @Override
    public void printStackTrace(@NotNull PrintStream s) {
        this.processAll(throwable -> {
            throwable.printStackTrace(s);
            return "";
        }, s::print);
    }

    @Override
    public void printStackTrace(@NotNull PrintWriter s) {
        this.processAll(throwable -> {
            throwable.printStackTrace(s);
            return "";
        }, s::print);
    }

    @NotNull
    private CharSequence processAll(@NotNull Function<? super Throwable, String> exceptionProcessor, @Nullable Consumer<? super String> stringProcessor) {
        if (this.exceptions.size() == 1) {
            Throwable throwable = this.exceptions.get(0);
            String s = exceptionProcessor.apply(throwable);
            if (stringProcessor != null) {
                stringProcessor.accept(s);
            }
            return s;
        }
        StringBuilder sb = new StringBuilder();
        String line = "CompositeException (" + this.exceptions.size() + " nested):\n------------------------------\n";
        if (stringProcessor != null) {
            stringProcessor.accept(line);
        }
        sb.append(line);
        for (int i = 0; i < this.exceptions.size(); ++i) {
            Throwable exception = this.exceptions.get(i);
            line = "[" + (i + 1) + "]: ";
            if (stringProcessor != null) {
                stringProcessor.accept(line);
            }
            sb.append(line);
            line = exceptionProcessor.apply(exception);
            if (line == null) {
                line = "null\n";
            } else if (!line.endsWith("\n")) {
                line = line + '\n';
            }
            if (stringProcessor != null) {
                stringProcessor.accept(line);
            }
            sb.append(line);
        }
        line = "------------------------------\n";
        if (stringProcessor != null) {
            stringProcessor.accept(line);
        }
        sb.append(line);
        return sb;
    }

    public static void throwIfNotEmpty(@Nullable List<? extends Throwable> throwables) {
        if (throwables == null || throwables.isEmpty()) {
            return;
        }
        if (throwables.size() != 1) {
            throw new CompoundRuntimeException(throwables);
        }
        ExceptionUtil.rethrow(throwables.get(0));
    }
}

