/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Loader;
import com.intellij.util.lang.StrippedLongSet;
import com.intellij.util.lang.StrippedLongToObjectMap;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.xxh3.Xx3UnencodedString;

@ApiStatus.Internal
public final class ClasspathCache {
    public static final String CLASS_EXTENSION = ".class";
    private static final IntFunction<Loader[][]> ARRAY_FACTORY = size -> new Loader[size][];
    private StrippedLongToObjectMap<Loader[]> classPackageCache;
    private StrippedLongToObjectMap<Loader[]> resourcePackageCache;
    private static final LongFunction<Loader[]> NULL = value -> null;
    private volatile LongFunction<Loader[]> classPackageCacheGetter = NULL;
    private volatile LongFunction<Loader[]> resourcePackageCacheGetter = NULL;

    void clearCache() {
        this.classPackageCacheGetter = NULL;
        this.resourcePackageCacheGetter = NULL;
        this.classPackageCache = null;
        this.resourcePackageCache = null;
    }

    void applyLoaderData(@NotNull IndexRegistrar registrar, @NotNull Loader loader) {
        if (registrar.classPackageCount() != 0) {
            StrippedLongToObjectMap<Loader[]> newClassMap = this.classPackageCache == null ? new StrippedLongToObjectMap<Loader[]>(ARRAY_FACTORY, registrar.classPackageCount()) : new StrippedLongToObjectMap<Loader[]>(this.classPackageCache);
            ClasspathCache.addPackages(registrar.classPackages(), newClassMap, loader, registrar.getKeyFilter(true));
            this.classPackageCache = newClassMap;
            this.classPackageCacheGetter = newClassMap;
        }
        if (registrar.resourcePackageCount() != 0) {
            StrippedLongToObjectMap<Loader[]> newResourceMap = this.resourcePackageCache == null ? new StrippedLongToObjectMap<Loader[]>(ARRAY_FACTORY, registrar.resourcePackageCount()) : new StrippedLongToObjectMap<Loader[]>(this.resourcePackageCache);
            this.resourcePackageCache = newResourceMap;
            this.resourcePackageCacheGetter = newResourceMap;
            ClasspathCache.addPackages(registrar.resourcePackages(), newResourceMap, loader, registrar.getKeyFilter(false));
        }
    }

    Loader @Nullable [] getLoadersByName(@NotNull String path) {
        return (path.endsWith(CLASS_EXTENSION) ? this.classPackageCacheGetter : this.resourcePackageCacheGetter).apply(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
    }

    Loader @Nullable [] getLoadersByResourcePackageDir(@NotNull String resourcePath) {
        return this.resourcePackageCacheGetter.apply(ClasspathCache.getPackageNameHash(resourcePath, resourcePath.length()));
    }

    Loader @Nullable [] getClassLoadersByPackageNameHash(long packageNameHash) {
        return this.classPackageCacheGetter.apply(packageNameHash);
    }

    public static long getPackageNameHash(@NotNull String resourcePath, int endIndex) {
        return endIndex <= 0 ? 0L : Xx3UnencodedString.hashUnencodedStringRange(resourcePath, 0, endIndex);
    }

    private static void addPackages(long[] hashes, StrippedLongToObjectMap<Loader[]> map, Loader loader, @Nullable LongPredicate hashFilter) {
        Loader[] singleArray = null;
        for (long hash : hashes) {
            if (hashFilter != null && !hashFilter.test(hash)) continue;
            int index = map.index(hash);
            if (index < 0) {
                if (singleArray == null) {
                    singleArray = new Loader[]{loader};
                }
                map.addByIndex(index, hash, singleArray);
                continue;
            }
            Loader[] loaders = map.getByIndex(index);
            Loader[] newList = new Loader[loaders.length + 1];
            System.arraycopy(loaders, 0, newList, 0, loaders.length);
            newList[loaders.length] = loader;
            map.replaceByIndex(index, hash, newList);
        }
    }

    public static interface IndexRegistrar {
        default public Predicate<String> getNameFilter() {
            return null;
        }

        public int classPackageCount();

        public int resourcePackageCount();

        public long[] classPackages();

        public long[] resourcePackages();

        @Nullable
        default public LongPredicate getKeyFilter(boolean forClasses) {
            return null;
        }
    }

    static final class LoaderDataBuilder
    implements IndexRegistrar {
        final StrippedLongSet classPackageHashes = new StrippedLongSet();
        final StrippedLongSet resourcePackageHashes = new StrippedLongSet();

        LoaderDataBuilder() {
        }

        @Override
        public int classPackageCount() {
            return this.classPackageHashes.size();
        }

        @Override
        public int resourcePackageCount() {
            return this.resourcePackageHashes.size();
        }

        @Override
        public long[] classPackages() {
            return this.classPackageHashes.keys;
        }

        @Override
        public long[] resourcePackages() {
            return this.resourcePackageHashes.keys;
        }

        @Override
        public LongPredicate getKeyFilter(final boolean forClasses) {
            return new LongPredicate(){
                boolean addZero;
                {
                    this.addZero = forClasses ? classPackageHashes.hasNull() : resourcePackageHashes.hasNull();
                }

                @Override
                public boolean test(long it) {
                    if (it == 0L) {
                        if (!this.addZero) {
                            return false;
                        }
                        this.addZero = false;
                    }
                    return true;
                }
            };
        }

        void addResourcePackage(@NotNull String path) {
            this.resourcePackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        void addPackageFromName(@NotNull String path) {
            StrippedLongSet set = path.endsWith(ClasspathCache.CLASS_EXTENSION) ? this.classPackageHashes : this.resourcePackageHashes;
            set.add(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
        }

        void addClassPackage(@NotNull String path) {
            this.classPackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }
    }
}

