/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.JdkZipResourceFile;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClassPath {
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";
    static final boolean recordLoadingInfo = Boolean.getBoolean("idea.record.classpath.info");
    static final boolean recordLoadingTime = recordLoadingInfo || Boolean.getBoolean("idea.record.classloading.stats");
    static final boolean logLoadingInfo = Boolean.getBoolean("idea.log.classpath.info");
    private static final boolean isNewClassLoadingEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.new.classloading.enabled", "false"));
    private static final Collection<Map.Entry<String, Path>> loadedClasses;
    private static final Measurer classLoading;
    private static final Measurer resourceLoading;
    private static final AtomicLong classDefineTotalTime;
    private final List<Path> files;
    @Nullable
    private final Function<Path, ResourceFile> resourceFileFactory;
    final boolean mimicJarUrlConnection;
    private final List<Loader> loaders = new ArrayList<Loader>();
    private volatile boolean allUrlsWereProcessed;
    private final AtomicInteger lastLoaderProcessed = new AtomicInteger();
    private final Set<Path> processedPaths = new HashSet<Path>();
    private final ClasspathCache cache = new ClasspathCache();
    final boolean lockJars;
    private final boolean useCache;
    final boolean isClassPathIndexEnabled;
    @Nullable
    private final CachePoolImpl cachePool;
    @Nullable
    private final Predicate<? super Path> cachingCondition;

    @Nullable
    public Function<Path, ResourceFile> getResourceFileFactory() {
        return this.resourceFileFactory;
    }

    public ClassPath(@NotNull List<Path> files2, @NotNull UrlClassLoader.Builder configuration, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean mimicJarUrlConnection) {
        this.lockJars = configuration.lockJars;
        this.useCache = configuration.useCache;
        this.cachePool = configuration.cachePool;
        this.cachingCondition = configuration.cachingCondition;
        this.isClassPathIndexEnabled = configuration.isClassPathIndexEnabled;
        this.mimicJarUrlConnection = mimicJarUrlConnection;
        this.files = new ArrayList<Path>(files2.size());
        this.resourceFileFactory = resourceFileFactory;
        if (!files2.isEmpty()) {
            for (int i = files2.size() - 1; i >= 0; --i) {
                this.files.add(files2.get(i));
            }
        }
    }

    public synchronized void reset(@NotNull List<Path> paths) {
        this.lastLoaderProcessed.set(0);
        this.allUrlsWereProcessed = false;
        this.loaders.clear();
        this.processedPaths.clear();
        this.cache.clearCache();
        this.addFiles(paths);
    }

    @NotNull
    public static Collection<Map.Entry<String, Path>> getLoadedClasses() {
        return new ArrayList<Map.Entry<String, Path>>(loadedClasses);
    }

    @NotNull
    public static Map<String, Long> getLoadingStats() {
        HashMap<String, Long> result = new HashMap<String, Long>(5);
        result.put("classLoadingTime", classLoading.timeCounter.get());
        result.put("classDefineTime", classDefineTotalTime.get());
        result.put("classRequests", Long.valueOf(classLoading.requestCounter.get()));
        result.put("resourceLoadingTime", resourceLoading.timeCounter.get());
        result.put("resourceRequests", Long.valueOf(resourceLoading.requestCounter.get()));
        result.put("identity", Long.valueOf(ClassPath.class.hashCode()));
        return result;
    }

    synchronized void addFiles(@NotNull List<Path> files2) {
        for (int i = files2.size() - 1; i >= 0; --i) {
            this.files.add(files2.get(i));
        }
        this.allUrlsWereProcessed = false;
    }

    public synchronized void appendFiles(@NotNull List<Path> newList) {
        if (newList.isEmpty()) {
            return;
        }
        HashSet<Path> existing = new HashSet<Path>(this.files);
        for (int i = newList.size() - 1; i >= 0; --i) {
            Path file2 = newList.get(i);
            if (existing.contains(file2)) continue;
            this.files.add(file2);
        }
        this.allUrlsWereProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Class<?> findClass(String className, String fileName, long packageNameHash, ClassDataConsumer classDataConsumer) throws IOException {
        long start = classLoading.startTiming();
        try {
            int i;
            block12: {
                Loader[] loaderArray;
                block10: {
                    int n;
                    block11: {
                        block9: {
                            if (!this.useCache) break block9;
                            Loader[] loaders = this.cache.getClassLoadersByPackageNameHash(packageNameHash);
                            if (loaders == null) break block10;
                            loaderArray = loaders;
                            n = loaderArray.length;
                            break block11;
                        }
                        i = 0;
                        break block12;
                    }
                    for (int j = 0; j < n; ++j) {
                        Class<?> result;
                        Loader loader = loaderArray[j];
                        if (!loader.containsName(fileName) || (result = ClassPath.findClassInLoader(fileName, className, classDataConsumer, loader)) == null) continue;
                        Class<?> clazz = result;
                        return clazz;
                    }
                }
                if (this.allUrlsWereProcessed) {
                    if (!isNewClassLoadingEnabled) {
                        loaderArray = null;
                        return loaderArray;
                    }
                    i = 0;
                } else {
                    i = this.lastLoaderProcessed.get();
                }
            }
            Class<?> clazz = this.findClassWithoutCache(className, fileName, i, classDataConsumer);
            return clazz;
        }
        finally {
            classLoading.record(start, className);
        }
    }

    @Nullable
    private Class<?> findClassWithoutCache(String className, String fileName, int loaderIndex, ClassDataConsumer classDataConsumer) throws IOException {
        Class<?> result;
        Loader loader;
        boolean useCache;
        do {
            int i;
            useCache = this.useCache;
            if ((i = loaderIndex++) < this.lastLoaderProcessed.get()) {
                loader = this.loaders.get(i);
                useCache = !isNewClassLoadingEnabled;
            } else {
                loader = this.getLoaderSlowPath(i);
            }
            if (loader != null) continue;
            return null;
        } while (useCache && !loader.containsName(fileName) || (result = ClassPath.findClassInLoader(fileName, className, classDataConsumer, loader)) == null);
        return result;
    }

    @Nullable
    private static Class<?> findClassInLoader(@NotNull String fileName, @NotNull String className, @NotNull ClassDataConsumer classConsumer, @NotNull Loader loader) throws IOException {
        Class<?> result = loader.findClass(fileName, className, classConsumer);
        if (result == null) {
            return null;
        }
        if (loadedClasses != null) {
            loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(fileName, loader.getPath()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Resource findResource(@NotNull String resourceName) {
        long start = resourceLoading.startTiming();
        try {
            Loader loader;
            int i;
            if (this.useCache) {
                Loader[] loaders = this.cache.getLoadersByName(resourceName);
                if (loaders != null) {
                    for (Loader loader2 : loaders) {
                        Resource resource;
                        if (!loader2.containsName(resourceName) || (resource = loader2.getResource(resourceName)) == null) continue;
                        if (loadedClasses != null) {
                            loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(resourceName, loader2.getPath()));
                        }
                        Resource resource2 = resource;
                        return resource2;
                    }
                }
                if (this.allUrlsWereProcessed) {
                    Loader[] loaderArray = null;
                    return loaderArray;
                }
                i = this.lastLoaderProcessed.get();
            } else {
                i = 0;
            }
            while ((loader = this.getLoader(i++)) != null) {
                if (this.useCache && !loader.containsName(resourceName)) continue;
                Resource resource = loader.getResource(resourceName);
                if (resource == null) continue;
                if (loadedClasses != null) {
                    loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(resourceName, loader.getPath()));
                }
                Resource resource3 = resource;
                return resource3;
            }
        }
        finally {
            resourceLoading.record(start, resourceName);
        }
        return null;
    }

    @NotNull
    public Enumeration<URL> getResources(@NotNull String name) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (this.useCache && this.allUrlsWereProcessed) {
            Loader[] loaders = this.cache.getLoadersByName(name);
            return loaders == null || loaders.length == 0 ? Collections.emptyEnumeration() : new ResourceEnumeration(name, loaders);
        }
        return new UncachedResourceEnumeration(name, this);
    }

    void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        block3: {
            Loader loader;
            block2: {
                if (!this.useCache || !this.allUrlsWereProcessed) break block2;
                Loader[] loaders = this.cache.getLoadersByResourcePackageDir(dir);
                if (loaders == null) break block3;
                for (Loader loader2 : loaders) {
                    loader2.processResources(dir, fileNameFilter, consumer);
                }
                break block3;
            }
            int index = 0;
            while ((loader = this.getLoader(index++)) != null) {
                loader.processResources(dir, fileNameFilter, consumer);
            }
        }
    }

    @Nullable
    private Loader getLoader(int i) {
        return i < this.lastLoaderProcessed.get() ? this.loaders.get(i) : this.getLoaderSlowPath(i);
    }

    @Nullable
    private synchronized Loader getLoaderSlowPath(int i) {
        while (this.loaders.size() < i + 1) {
            int size = this.files.size();
            if (size == 0) {
                if (this.useCache) {
                    this.allUrlsWereProcessed = true;
                }
                return null;
            }
            Path path = this.files.remove(size - 1);
            if (this.processedPaths.contains(path)) continue;
            try {
                Loader loader = this.createLoader(path);
                if (loader == null) continue;
                if (this.useCache && this.files.isEmpty()) {
                    this.allUrlsWereProcessed = true;
                }
                this.loaders.add(loader);
                this.processedPaths.add(path);
                this.lastLoaderProcessed.incrementAndGet();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.loaders.get(i);
    }

    @NotNull
    public List<Path> getBaseUrls() {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Loader loader : this.loaders) {
            result.add(loader.getPath());
        }
        return result;
    }

    @Nullable
    private Loader createLoader(@NotNull Path file2) throws IOException {
        String filePath;
        BasicFileAttributes fileAttributes;
        try {
            fileAttributes = Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to read attributes of file from " + file2.getFileSystem(), e);
        }
        if (fileAttributes.isDirectory()) {
            return this.useCache ? FileLoader.createCachingFileLoader(file2, this.cachePool, this.cachingCondition, this.isClassPathIndexEnabled, this.cache) : new FileLoader(file2);
        }
        if (!fileAttributes.isRegularFile()) {
            return null;
        }
        ResourceFile zipFile = this.resourceFileFactory == null ? new JdkZipResourceFile(file2, this.lockJars) : this.resourceFileFactory.apply(file2);
        JarLoader loader = new JarLoader(file2, this, zipFile);
        if (this.useCache) {
            ClasspathCache.IndexRegistrar data;
            ClasspathCache.IndexRegistrar indexRegistrar = data = this.cachePool == null ? null : this.cachePool.loaderIndexCache.get(file2);
            if (data == null) {
                data = zipFile.buildClassPathCacheData();
                if (this.cachePool != null && this.cachingCondition != null && this.cachingCondition.test(file2)) {
                    this.cachePool.loaderIndexCache.put(file2, data);
                }
            }
            this.cache.applyLoaderData(data, loader);
        }
        if ((filePath = file2.toString()).startsWith(CLASSPATH_JAR_FILE_NAME_PREFIX, filePath.lastIndexOf(File.separatorChar) + 1)) {
            this.addFromManifestClassPathIfNeeded(file2, zipFile, loader);
        }
        return loader;
    }

    private void addFromManifestClassPathIfNeeded(@NotNull Path file2, ResourceFile zipFile, JarLoader loader) {
        String[] referencedJars = this.loadManifestClasspath(loader, zipFile);
        if (referencedJars != null) {
            long startReferenced = logLoadingInfo ? System.nanoTime() : 0L;
            ArrayList<Path> urls = new ArrayList<Path>(referencedJars.length);
            for (String referencedJar : referencedJars) {
                try {
                    urls.add(Paths.get(UrlClassLoader.urlToFilePath(referencedJar), new String[0]));
                }
                catch (Exception e) {
                    System.err.println("file: " + file2 + " / " + referencedJar + " " + e);
                }
            }
            this.addFiles(urls);
            if (logLoadingInfo) {
                System.out.println("Loaded all " + referencedJars.length + " files " + (System.nanoTime() - startReferenced) / 1000000L + "ms");
            }
        }
    }

    private String @Nullable [] loadManifestClasspath(@NotNull JarLoader loader, @NotNull ResourceFile zipFile) {
        try {
            String[] urls;
            String classPath;
            Map<JarLoader.Attribute, String> result;
            Map<JarLoader.Attribute, String> map = result = this.useCache && this.cachePool != null ? this.cachePool.getManifestData(loader.getPath()) : null;
            if (result == null) {
                Attributes manifestAttributes = zipFile.loadManifestAttributes();
                Map<Object, Object> map2 = result = manifestAttributes == null ? Collections.emptyMap() : JarLoader.getAttributes(manifestAttributes);
                if (this.useCache && this.cachePool != null && this.cachingCondition != null && this.cachingCondition.test(loader.getPath())) {
                    this.cachePool.cacheManifestData(loader.getPath(), result);
                }
            }
            if ((classPath = (String)result.get((Object)JarLoader.Attribute.CLASS_PATH)) != null && (urls = classPath.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        classLoading = new Measurer();
        resourceLoading = new Measurer();
        classDefineTotalTime = new AtomicLong();
        ConcurrentLinkedQueue concurrentLinkedQueue = loadedClasses = recordLoadingInfo ? new ConcurrentLinkedQueue() : null;
        if (logLoadingInfo) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> System.out.println("Classloading requests: " + ClassPath.class.getClassLoader() + ", class=" + classLoading + ", resource=" + resourceLoading), "Shutdown hook for tracing classloading information"));
        }
    }

    private static final class Measurer {
        private final AtomicLong timeCounter = new AtomicLong();
        private final AtomicInteger requestCounter = new AtomicInteger();
        private final ThreadLocal<Boolean> doingTiming = new ThreadLocal();

        private Measurer() {
        }

        long startTiming() {
            if (!recordLoadingTime || this.doingTiming.get() != null) {
                return -1L;
            }
            this.doingTiming.set(Boolean.TRUE);
            return System.nanoTime();
        }

        void record(long start, String resourceName) {
            if (start == -1L) {
                return;
            }
            this.doingTiming.set(null);
            long time = System.nanoTime() - start;
            long totalTime = this.timeCounter.addAndGet(time);
            int totalRequests = this.requestCounter.incrementAndGet();
            if (logLoadingInfo) {
                if (time > 3000000L) {
                    System.out.println(TimeUnit.NANOSECONDS.toMillis(time) + " ms for " + resourceName);
                }
                if (totalRequests % 10000 == 0) {
                    System.out.println(ClassPath.class.getClassLoader() + ", requests: " + totalRequests + ", time:" + TimeUnit.NANOSECONDS.toMillis(totalTime) + "ms");
                }
            }
        }

        public String toString() {
            return "Measurer(time=" + TimeUnit.NANOSECONDS.toMillis(this.timeCounter.get()) + "ms, requests=" + this.requestCounter + ')';
        }
    }

    static interface ClassDataConsumer {
        public boolean isByteBufferSupported(String var1);

        public Class<?> consumeClassData(String var1, byte[] var2, Loader var3) throws IOException;

        public Class<?> consumeClassData(String var1, ByteBuffer var2, Loader var3) throws IOException;
    }

    private static final class ResourceEnumeration
    implements Enumeration<URL> {
        private int index;
        private Resource resource;
        private final String name;
        private final Loader[] loaders;

        ResourceEnumeration(@NotNull String name, Loader[] loaders) {
            this.name = name;
            this.loaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.resource != null) {
                return true;
            }
            long start = resourceLoading.startTiming();
            try {
                while (this.index < this.loaders.length) {
                    Loader loader;
                    if (!(loader = this.loaders[this.index++]).containsName(this.name)) {
                        this.resource = null;
                        continue;
                    }
                    this.resource = loader.getResource(this.name);
                    if (this.resource == null) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                resourceLoading.record(start, this.name);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.resource;
            this.resource = null;
            return resource.getURL();
        }
    }

    private static final class UncachedResourceEnumeration
    implements Enumeration<URL> {
        private int index;
        private Resource resource;
        private final String name;
        private final ClassPath classPath;

        UncachedResourceEnumeration(@NotNull String name, @NotNull ClassPath classPath) {
            this.name = name;
            this.classPath = classPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.resource != null) {
                return true;
            }
            long start = resourceLoading.startTiming();
            try {
                Loader loader;
                while ((loader = this.classPath.getLoader(this.index++)) != null) {
                    if (this.classPath.useCache && !loader.containsName(this.name)) continue;
                    this.resource = loader.getResource(this.name);
                    if (this.resource == null) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                resourceLoading.record(start, this.name);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.resource;
            this.resource = null;
            return resource.getURL();
        }
    }

    static final class MeasuringClassDataConsumer
    implements ClassDataConsumer {
        private static final ThreadLocal<Boolean> doingClassDefineTiming = new ThreadLocal();
        private final ClassDataConsumer classDataConsumer;

        MeasuringClassDataConsumer(ClassDataConsumer classDataConsumer) {
            this.classDataConsumer = classDataConsumer;
        }

        @Override
        public boolean isByteBufferSupported(String name) {
            return this.classDataConsumer.isByteBufferSupported(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> consumeClassData(String name, byte[] data, Loader loader) throws IOException {
            long start = MeasuringClassDataConsumer.startTiming();
            try {
                Class<?> clazz = this.classDataConsumer.consumeClassData(name, data, loader);
                return clazz;
            }
            finally {
                MeasuringClassDataConsumer.record(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> consumeClassData(String name, ByteBuffer data, Loader loader) throws IOException {
            long start = MeasuringClassDataConsumer.startTiming();
            try {
                Class<?> clazz = this.classDataConsumer.consumeClassData(name, data, loader);
                return clazz;
            }
            finally {
                MeasuringClassDataConsumer.record(start);
            }
        }

        private static long startTiming() {
            if (doingClassDefineTiming.get() != null) {
                return -1L;
            }
            doingClassDefineTiming.set(Boolean.TRUE);
            return System.nanoTime();
        }

        private static void record(long start) {
            if (start != -1L) {
                doingClassDefineTiming.set(null);
                classDefineTotalTime.addAndGet(System.nanoTime() - start);
            }
        }
    }
}

