/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ClassLoadingLocks<T> {
    private final ConcurrentMap<T, WeakLockReference<T>> myMap = new ConcurrentHashMap<T, WeakLockReference<T>>();
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();

    @NotNull
    public Object getOrCreateLock(@NotNull T className) {
        WeakLockReference oldRef;
        Object lock;
        WeakLockReference lockReference = (WeakLockReference)this.myMap.get(className);
        if (lockReference != null && (lock = lockReference.get()) != null) {
            return lock;
        }
        Object newLock = new Object();
        WeakLockReference newRef = new WeakLockReference(className, newLock, this.myQueue);
        do {
            this.processQueue();
            oldRef = this.myMap.putIfAbsent(className, newRef);
            if (oldRef == null) {
                return newLock;
            }
            Object oldLock = oldRef.get();
            if (oldLock == null) continue;
            return oldLock;
        } while (!this.myMap.replace(className, oldRef, newRef));
        return newLock;
    }

    private void processQueue() {
        WeakLockReference ref;
        while ((ref = (WeakLockReference)this.myQueue.poll()) != null) {
            this.myMap.remove(ref.myClassName, ref);
        }
    }

    private static final class WeakLockReference<T>
    extends WeakReference<Object> {
        final T myClassName;

        private WeakLockReference(@NotNull T className, @NotNull Object lock, @NotNull ReferenceQueue<Object> q) {
            super(lock, q);
            this.myClassName = className;
        }
    }
}

