/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public final class ByteBufferCleaner {
    private static volatile MethodHandle cleaner;

    public static void unmapBuffer(@NotNull ByteBuffer buffer) throws Exception {
        if (!buffer.isDirect()) {
            return;
        }
        MethodHandle cleaner = ByteBufferCleaner.cleaner;
        try {
            if (cleaner == null) {
                cleaner = ByteBufferCleaner.getByteBufferCleaner();
            }
            cleaner.invokeExact(buffer);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static synchronized MethodHandle getByteBufferCleaner() throws Throwable {
        MethodHandle cleaner = ByteBufferCleaner.cleaner;
        if (cleaner != null) {
            return cleaner;
        }
        Class<?> unsafeClass = ClassLoader.getPlatformClassLoader().loadClass("sun.misc.Unsafe");
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(unsafeClass, MethodHandles.lookup());
        Object unsafe = lookup.findStaticGetter(unsafeClass, "theUnsafe", unsafeClass).invoke();
        ByteBufferCleaner.cleaner = cleaner = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class)).bindTo(unsafe);
        return cleaner;
    }
}

