/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class MapBackedFMap
extends Int2ObjectOpenHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, int keyToExclude) {
        super(oldMap.size());
        oldMap.int2ObjectEntrySet().fastForEach(entry -> {
            int key = entry.getIntKey();
            if (key != keyToExclude) {
                this.put(key, entry.getValue());
            }
            assert (key >= 0) : key;
        });
        assert (this.size() > 8);
    }

    private MapBackedFMap(@NotNull MapBackedFMap oldMap, int newKey, @NotNull Object newValue) {
        super(oldMap.size() + 1);
        this.putAll((Map)((Object)oldMap));
        this.put(newKey, newValue);
        assert (this.size() > 8);
    }

    MapBackedFMap(int @NotNull [] keys, int newKey, @NotNull @NotNull Object @NotNull [] values, @NotNull Object newValue) {
        super(keys.length + 1);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            this.put(key, values[i]);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        return value == oldValue ? this : new MapBackedFMap(this, keyCode, value);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            return this;
        }
        if (oldSize == 9) {
            int[] keys = this.keySet().toIntArray();
            int[] newKeys = ArrayUtil.remove(keys, ArrayUtil.indexOf(keys, keyCode));
            Arrays.sort(newKeys);
            Object[] newValues = new Object[newKeys.length];
            for (int i = 0; i < newKeys.length; ++i) {
                Object value = this.get(newKeys[i]);
                assert (value != null);
                newValues[i] = value;
            }
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return new MapBackedFMap(this, keyCode);
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return (V)this.get(key.hashCode());
    }

    @Override
    public Key<?> @NotNull [] getKeys() {
        return ArrayBackedFMap.getKeysByIndices(this.keySet().toIntArray());
    }

    @Override
    public int getValueIdentityHashCode() {
        int hash = 0;
        ObjectIterator iterator = this.int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int key = entry.getIntKey();
            hash = (hash * 31 + key) * 31 + System.identityHashCode(entry.getValue());
        }
        return hash;
    }

    @Override
    public boolean equalsByReference(@NotNull KeyFMap other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MapBackedFMap) || other.size() != this.size()) {
            return false;
        }
        MapBackedFMap map = (MapBackedFMap)other;
        ObjectIterator iterator = this.int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry next = (Int2ObjectMap.Entry)iterator.next();
            if (map.get(next.getIntKey()) == next.getValue()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.int2ObjectEntrySet().fastForEach(entry -> s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(entry.getIntKey())).append(" -> ").append(entry.getValue()));
        return "[" + s + "]";
    }
}

