/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.util.io.zip.JBZipExtraField;
import com.intellij.util.io.zip.ZipShort;
import com.intellij.util.io.zip.ZipUInt64;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

public class Zip64ExtraField
implements JBZipExtraField {
    static final ZipShort HEADER_ID = new ZipShort(1);
    private static final byte[] EMPTY = new byte[0];
    private ZipUInt64 mySize;
    private ZipUInt64 myCompressedSize;
    private ZipUInt64 myHeaderOffset;

    Zip64ExtraField() {
    }

    public Zip64ExtraField(ZipUInt64 size, ZipUInt64 compressedSize, ZipUInt64 headerOffset) {
        this.mySize = size;
        this.myCompressedSize = compressedSize;
        this.myHeaderOffset = headerOffset;
    }

    @Override
    @NotNull
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    @Override
    @NotNull
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.mySize != null ? 16 : 0);
    }

    @Override
    @NotNull
    public ZipShort getCentralDirectoryLength() {
        return new ZipShort((this.mySize != null ? 8 : 0) + (this.myCompressedSize != null ? 8 : 0) + (this.myHeaderOffset != null ? 8 : 0));
    }

    @Override
    public byte @NotNull [] getLocalFileDataData() {
        if (this.mySize != null || this.myCompressedSize != null) {
            if (this.mySize == null || this.myCompressedSize == null) {
                throw new IllegalArgumentException("Must contain both size values in the local file header");
            }
            byte[] data = new byte[16];
            this.addSizes(data);
            return data;
        }
        return EMPTY;
    }

    @Override
    public byte @NotNull [] getCentralDirectoryData() {
        byte[] data = new byte[this.getCentralDirectoryLength().getValue()];
        int off = this.addSizes(data);
        if (this.myHeaderOffset != null) {
            System.arraycopy(this.myHeaderOffset.getBytes(), 0, data, off, 8);
        }
        return data;
    }

    @Override
    public void parseFromLocalFileData(byte @NotNull [] buffer, int offset, int length) throws ZipException {
        if (length == 0) {
            return;
        }
        if (length < 16) {
            throw new ZipException("Must contain both size values in the local file header.");
        }
        this.mySize = new ZipUInt64(buffer, offset);
        this.myCompressedSize = new ZipUInt64(buffer, offset += 8);
        offset += 8;
        int remaining = length - 16;
        if (remaining >= 8) {
            this.myHeaderOffset = new ZipUInt64(buffer, offset);
        }
    }

    @Override
    public void parseFromCentralDirectoryData(byte @NotNull [] buffer, int offset, int length) throws ZipException {
        this.mySize = new ZipUInt64(buffer, offset);
        this.myCompressedSize = new ZipUInt64(buffer, offset += 8);
        this.myHeaderOffset = new ZipUInt64(buffer, offset += 8);
    }

    public ZipUInt64 getSize() {
        return this.mySize;
    }

    public ZipUInt64 getCompressedSize() {
        return this.myCompressedSize;
    }

    public ZipUInt64 getHeaderOffset() {
        return this.myHeaderOffset;
    }

    private int addSizes(byte[] data) {
        int off = 0;
        if (this.mySize != null) {
            System.arraycopy(this.mySize.getBytes(), 0, data, 0, 8);
            off += 8;
        }
        if (this.myCompressedSize != null) {
            System.arraycopy(this.myCompressedSize.getBytes(), 0, data, off, 8);
            off += 8;
        }
        return off;
    }
}

