/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.zip.JBZipExtraField;
import com.intellij.util.io.zip.JBZipFile;
import com.intellij.util.io.zip.JBZipOutputStream;
import com.intellij.util.io.zip.UnrecognizedExtraField;
import com.intellij.util.io.zip.Zip64ExtraField;
import com.intellij.util.io.zip.ZipShort;
import com.intellij.util.io.zip.ZipUInt64;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

public class JBZipEntry
implements Cloneable {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private long time = -1L;
    private long crc = -1L;
    private long size = -1L;
    private long csize = -1L;
    private int method = -1;
    private List<JBZipExtraField> extra = new SmartList<JBZipExtraField>();
    private String comment;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private String name;
    private long headerOffset = -1L;
    private final JBZipFile myFile;

    protected JBZipEntry(String name, JBZipFile file2) {
        this.name = name;
        this.myFile = file2;
    }

    protected JBZipEntry(JBZipFile file2) {
        this.name = "";
        this.myFile = file2;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    public long getHeaderOffset() {
        return this.headerOffset;
    }

    public void setHeaderOffset(long headerOffset) {
        this.headerOffset = headerOffset;
    }

    public void setUnixMode(int mode) {
        this.setExternalAttributes((long)(mode & 0xFFFF) << 16 | (long)((mode & 0x80) == 0 ? 1 : 0) | (long)(this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    void setExtra(@NotNull List<JBZipExtraField> extra) {
        this.extra = extra;
    }

    public void addExtra(@NotNull JBZipExtraField field) {
        JBZipExtraField current = (JBZipExtraField)ContainerUtil.find(this.extra, f -> f.getHeaderId().equals(field.getHeaderId()));
        if (current != null) {
            this.extra.remove(current);
        }
        this.extra.add(field);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setSize(long size) {
        if (size < 0L || size > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long csize) {
        this.csize = csize;
    }

    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("invalid compression method: " + method);
        }
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void erase() throws IOException {
        this.myFile.eraseEntry(this);
    }

    private InputStream getInputStream() throws IOException {
        this.myFile.ensureFlushed(this.getHeaderOffset() + 26L + 4L);
        long start = this.calcDataOffset();
        long size = this.getCompressedSize();
        this.myFile.ensureFlushed(start + size);
        if (this.myFile.myArchive.length() < start + size) {
            throw new EOFException();
        }
        BoundedInputStream bis = new BoundedInputStream(start, size);
        switch (this.getMethod()) {
            case 0: {
                return bis;
            }
            case 8: {
                bis.addDummy();
                return new InflaterInputStream(bis, new Inflater(true));
            }
        }
        throw new ZipException("Found unsupported compression method " + this.getMethod());
    }

    @NotNull
    public List<JBZipExtraField> getExtra() {
        return this.extra;
    }

    byte @NotNull [] getCentralDirectoryExtraBytes() throws IOException {
        BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
        for (JBZipExtraField field : this.extra) {
            stream.write(field.getHeaderId().getBytes());
            stream.write(field.getCentralDirectoryLength().getBytes());
            stream.write(field.getCentralDirectoryData());
        }
        byte[] bytes = stream.toByteArray();
        JBZipEntry.assertValidExtraFieldSize(bytes);
        return bytes;
    }

    byte @NotNull [] getLocalFileHeaderDataExtra() throws IOException {
        BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
        for (JBZipExtraField field : this.extra) {
            stream.write(field.getHeaderId().getBytes());
            stream.write(field.getLocalFileDataLength().getBytes());
            stream.write(field.getLocalFileDataData());
        }
        byte[] bytes = stream.toByteArray();
        JBZipEntry.assertValidExtraFieldSize(bytes);
        return bytes;
    }

    private static void assertValidExtraFieldSize(byte @NotNull [] bytes) {
        if (bytes.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
    }

    void readExtraFromCentralDirectoryBytes(byte @NotNull [] extraBytes) throws IOException {
        UnsyncByteArrayInputStream stream = new UnsyncByteArrayInputStream(extraBytes);
        while (stream.available() > 0) {
            ZipUInt64 offset;
            ZipUInt64 size;
            ZipShort headerId = new ZipShort(JBZipEntry.readNBytes((InputStream)stream, 2));
            JBZipExtraField field = headerId.equals(Zip64ExtraField.HEADER_ID) ? new Zip64ExtraField() : new UnrecognizedExtraField(headerId);
            int length = ZipShort.getValue(JBZipEntry.readNBytes((InputStream)stream, 2));
            field.parseFromCentralDirectoryData(JBZipEntry.readNBytes((InputStream)stream, length), 0, length);
            this.addExtra(field);
            if (!(field instanceof Zip64ExtraField)) continue;
            Zip64ExtraField zip64ExtraField = (Zip64ExtraField)field;
            ZipUInt64 compressedSize = zip64ExtraField.getCompressedSize();
            if (compressedSize != null) {
                this.setCompressedSize(compressedSize.getLongValue());
            }
            if ((size = zip64ExtraField.getSize()) != null) {
                this.setSize(size.getLongValue());
            }
            if ((offset = zip64ExtraField.getHeaderOffset()) == null) continue;
            this.setHeaderOffset(offset.getLongValue());
        }
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 21845 && JBZipEntry.getUTF8Length(comment) > 65535) {
            throw new IllegalArgumentException("invalid entry comment length");
        }
        this.comment = comment;
    }

    private static int getUTF8Length(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public String getComment() {
        return this.comment;
    }

    public void setData(byte[] bytes, long timestamp) throws IOException {
        this.time = timestamp;
        JBZipOutputStream stream = this.myFile.getOutputStream();
        stream.putNextEntryBytes(this, bytes);
    }

    public void setData(byte[] bytes) throws IOException {
        this.setData(bytes, this.time);
    }

    public void setDataFromFile(File file2) throws IOException {
        if (file2.length() < (long)(FileUtilRt.LARGE_FOR_CONTENT_LOADING / 2)) {
            this.setData(FileUtil.loadFileBytes(file2));
        } else {
            this.doSetDataFromFile(file2);
        }
    }

    public void setDataFromStream(@NotNull InputStream stream) throws IOException {
        this.myFile.getOutputStream().putNextEntryContent(this, stream);
    }

    void doSetDataFromFile(File file2) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file2));){
            this.myFile.getOutputStream().putNextEntryContent(this, input);
            assert (this.getSize() == file2.length());
        }
    }

    public void setDataFromPath(@NotNull Path file2) throws IOException {
        long size = Files.size(file2);
        if (size < (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
            this.myFile.getOutputStream().putNextEntryBytes(this, Files.readAllBytes(file2));
        } else {
            try (InputStream input = Files.newInputStream(file2, new OpenOption[0]);){
                this.myFile.getOutputStream().putNextEntryContent(this, input);
            }
        }
    }

    public void writeDataTo(OutputStream output) throws IOException {
        if (this.size == -1L) {
            throw new IOException("no data");
        }
        InputStream stream = this.getInputStream();
        FileUtil.copy(stream, (int)this.size, output);
    }

    public byte[] getData() throws IOException {
        if (this.size == -1L) {
            throw new IOException("no data");
        }
        try (InputStream stream = this.getInputStream();){
            byte[] byArray = FileUtil.loadBytes(stream, (int)this.size);
            return byArray;
        }
    }

    public long calcDataOffset() throws IOException {
        long offset = this.getHeaderOffset();
        this.myFile.myArchive.seek(offset + 26L);
        byte[] b = new byte[4];
        this.myFile.myArchive.readFully(b);
        int fileNameLen = ZipShort.getValue(b, 0);
        int extraFieldLen = ZipShort.getValue(b, 2);
        return offset + 26L + 4L + (long)fileNameLen + (long)extraFieldLen;
    }

    private static byte[] readNBytes(@NotNull InputStream is, int length) throws IOException {
        int count;
        byte[] bytes = new byte[length];
        int off = 0;
        for (int n = 0; n < length; n += count) {
            count = is.read(bytes, off + n, length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return bytes;
    }

    public String toString() {
        return this.name;
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.loc = start;
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            RandomAccessFile archive = ((JBZipEntry)JBZipEntry.this).myFile.myArchive;
            archive.seek(this.loc);
            int ret = archive.read(b, off, len);
            if (ret > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile archive = ((JBZipEntry)JBZipEntry.this).myFile.myArchive;
            archive.seek(this.loc++);
            return archive.read();
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }
}

