/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class DataTable
implements Closeable,
Forceable {
    private static final Logger LOG = Logger.getInstance(DataTable.class);
    private static final int HEADER_SIZE = 32;
    private static final int DIRTY_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private final PagedFileStorage myFile;
    private volatile int myWasteSize;
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_WASTE_SIZE_OFFSET = 4;
    private volatile boolean myIsDirty;

    DataTable(@NotNull Path filePath, @NotNull StorageLockContext context) throws IOException {
        this.myFile = new PagedFileStorage(filePath, context, 8192, false, false);
        this.myFile.lockWrite();
        try {
            if (this.myFile.length() == 0L) {
                this.markDirty();
            } else {
                this.readInHeader(filePath);
            }
        }
        finally {
            this.myFile.unlockWrite();
        }
    }

    public boolean isCompactNecessary() {
        return (double)this.myWasteSize / (double)this.myFile.length() > 0.25 && this.myWasteSize > 0x300000;
    }

    private void readInHeader(@NotNull Path filePath) throws IOException {
        int magic = this.myFile.getInt(0L);
        if (magic != 523190095) {
            this.myFile.close();
            throw new IOException("Records table for '" + filePath + "' haven't been closed correctly. Rebuild required.");
        }
        this.myWasteSize = this.myFile.getInt(4L);
    }

    public void readBytes(long address, byte[] bytes) throws IOException {
        this.myFile.get(address, bytes, 0, bytes.length, true);
    }

    public void writeBytes(long address, byte[] bytes) throws IOException {
        this.writeBytes(address, bytes, 0, bytes.length);
    }

    public void writeBytes(long address, byte[] bytes, int off, int len) throws IOException {
        this.markDirty();
        this.myFile.put(address, bytes, off, len);
    }

    public long allocateSpace(int len) throws IOException {
        long result = Math.max(this.myFile.length(), 32L);
        long newLength = result + (long)len;
        this.writeBytes(newLength - 1L, new byte[]{0});
        long actualLength = this.myFile.length();
        if (actualLength != newLength) {
            LOG.error("Failed to resize the storage at: " + this.myFile + ". Required: " + newLength + ", actual: " + actualLength);
        }
        return result;
    }

    public void reclaimSpace(int len) throws IOException {
        if (len > 0) {
            this.markDirty();
            this.myWasteSize += len;
        }
    }

    @Override
    public void close() throws IOException {
        this.markClean();
        this.myFile.close();
    }

    @Override
    public void force() throws IOException {
        this.markClean();
        this.myFile.force();
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myFile.isDirty();
    }

    private void markClean() throws IOException {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.fillInHeader(523190095, this.myWasteSize);
        }
    }

    private void markDirty() throws IOException {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.fillInHeader(313341156, 0);
        }
    }

    private void fillInHeader(int magic, int wasteSize) throws IOException {
        this.myFile.putInt(0L, magic);
        this.myFile.putInt(4L, wasteSize);
    }

    public int getWaste() {
        return this.myWasteSize;
    }

    public long getFileSize() {
        return this.myFile.length();
    }
}

