/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        return ZipUtil.addFileToZip(zos, file2, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, file2.isDirectory());
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor, boolean isDir) throws IOException {
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        if (isDir && !Strings.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtilRt.isFilePathAcceptable((File)file2, (FileFilter)fileFilter) || writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file2 + " as " + relativeName);
        }
        long size = isDir ? 0L : file2.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file2.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            try (InputStream is = contentProcessor.getContent(file2);){
                FileUtilRt.copy((InputStream)is, (OutputStream)zos);
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file2, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (file2.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file2, relativePath, fileFilter, writtenItemRelativePaths);
        }
        return ZipUtil.addFileToZip(jarOutputStream, file2, relativePath, writtenItemRelativePaths, fileFilter);
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children2;
        if (jarFile != null && FileUtil.isAncestor(dir.getPath(), jarFile.getPath(), false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, true);
        }
        if ((children2 = dir.listFiles()) != null) {
            for (File child : children2) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    @Deprecated
    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter) throws IOException {
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir.toPath(), filter)).extract(outputDir.toPath());
    }

    public static void extract(@NotNull Path file2, @NotNull Path outputDir, @Nullable FilenameFilter filter) throws IOException {
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter)).extract(outputDir);
    }

    public static void extract(@NotNull Path file2, @NotNull Path outputDir, @Nullable FilenameFilter filter, boolean overwrite) throws IOException {
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter)).overwrite(overwrite).extract(outputDir);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter, boolean overwrite) throws IOException {
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir.toPath(), filter)).overwrite(overwrite).extract(outputDir);
    }

    public static boolean isZipContainsFolder(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        try (FileInputStream is = new FileInputStream(srcFile);
             ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));){
            os.putNextEntry(new ZipEntry(srcFile.getName()));
            FileUtilRt.copy((InputStream)is, (OutputStream)os);
            os.closeEntry();
        }
    }

    public static void compressFile(@NotNull Path srcFile, @NotNull Path zipFile) throws IOException {
        try (ZipOutputStream os = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            os.putNextEntry(new ZipEntry(srcFile.getFileName().toString()));
            Files.copy(srcFile, os);
            os.closeEntry();
        }
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(@NotNull File file2) throws IOException {
                return new FileInputStream(file2);
            }
        };

        public InputStream getContent(@NotNull File var1) throws IOException;
    }

    private static final class FileFilterAdapter
    implements Predicate<String> {
        private final File myOutputDir;
        private final FilenameFilter myFilter;

        private static FileFilterAdapter wrap(@NotNull Path outputDir, @Nullable FilenameFilter filter) {
            return filter == null ? null : new FileFilterAdapter(outputDir, filter);
        }

        private FileFilterAdapter(@NotNull Path outputDir, FilenameFilter filter) {
            this.myOutputDir = outputDir.toFile();
            this.myFilter = filter;
        }

        @Override
        public boolean test(String entryName) {
            File outputFile = new File(this.myOutputDir, entryName);
            return this.myFilter.accept(outputFile.getParentFile(), outputFile.getName());
        }
    }
}

