/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.UrlUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JRT_PROTOCOL = "jrt";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern URL_WITH_PARENS_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;()]*[-A-Za-z0-9+$&@#/%=~_|()]");
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\b(file:///)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");

    private URLUtil() {
    }

    public static boolean canContainUrl(@NotNull String line) {
        return line.contains("mailto:") || line.contains(SCHEME_SEPARATOR) || line.contains("www.");
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.equals(JAR_PROTOCOL)) {
            return url.openStream();
        }
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile((String)paths.first);
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        try {
            return URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file2 = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file2 = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file2 = url.getFile().substring(pos + 1);
            }
            if (file2 != null && file2.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file2)) != null) {
                return resourceStream;
            }
            throw ex;
        }
    }

    @NotNull
    public static ThreeState resourceExists(@NotNull URL url) {
        if (url.getProtocol().equals(FILE_PROTOCOL)) {
            return ThreeState.fromBoolean(URLUtil.urlToFile(url).exists());
        }
        if (url.getProtocol().equals(JAR_PROTOCOL)) {
            ThreeState threeState;
            Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
            if (paths == null) {
                return ThreeState.NO;
            }
            if (!new File((String)paths.first).isFile()) {
                return ThreeState.NO;
            }
            ZipFile file2 = new ZipFile((String)paths.first);
            try {
                threeState = ThreeState.fromBoolean(file2.getEntry((String)paths.second) != null);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        file2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ThreeState.NO;
                }
            }
            file2.close();
            return threeState;
        }
        return ThreeState.UNSURE;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block6: {
            int pivot = url.indexOf(JAR_SEPARATOR);
            if (pivot < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (jarPath.startsWith("jar:")) {
                jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
            }
            if (jarPath.startsWith(FILE_PROTOCOL)) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring(FILE_PROTOCOL.length());
                    if (jarPath.startsWith(SCHEME_SEPARATOR)) {
                        jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
                    }
                    if (jarPath.length() == 0 || jarPath.charAt(0) != ':') break block6;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url + "'", e);
        }
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        return URLUtil.unescapePercentSequences(s, 0, s.length()).toString();
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from, int end) {
        return UrlUtilRt.unescapePercentSequences(s, from, end);
    }

    public static boolean containsScheme(@NotNull String url) {
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(@NotNull String value) {
        return !value.isEmpty() && value.startsWith("data:", value.charAt(0) == '\"' || value.charAt(0) == '\'' ? 1 : 0);
    }

    public static byte @Nullable [] getBytesFromDataUri(@NotNull String dataUrl) {
        Matcher matcher = DATA_URI_PATTERN.matcher(StringUtilRt.unquoteString((String)dataUrl));
        if (matcher.matches()) {
            try {
                String content = matcher.group(4);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64.getDecoder().decode(content) : URLUtil.decode(content).getBytes(StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static String decode(@NotNull String string2) {
        try {
            return URLDecoder.decode(string2, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ignore) {
            return URLDecoder.decode(string2);
        }
    }

    @NotNull
    public static String parseHostFromSshUrl(@NotNull String sshUrl) {
        String host = sshUrl;
        int at = host.lastIndexOf(64);
        if (at > 0) {
            host = host.substring(at + 1);
        } else {
            int firstColon = host.indexOf(58);
            if (firstColon > 0) {
                host = host.substring(firstColon + 3);
            }
        }
        int colon = host.indexOf(58);
        if (colon > 0) {
            host = host.substring(0, colon);
        } else {
            int slash = host.indexOf(47);
            if (slash > 0) {
                host = host.substring(0, slash);
            }
        }
        return host;
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file2, @NotNull String pathInJar) throws MalformedURLException {
        int index;
        String fileURL = file2.toURI().toASCIIString().replace("!", "%21");
        for (index = 0; index < pathInJar.length() && pathInJar.charAt(index) == '/'; ++index) {
        }
        return new URL("jar:" + fileURL + JAR_SEPARATOR + pathInJar.substring(index));
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    @Nullable
    public static TextRange findUrl(@NotNull CharSequence text, int startOffset, int endOffset) {
        Matcher m = URL_WITH_PARENS_PATTERN.matcher(text);
        m.region(startOffset, endOffset);
        if (!m.find()) {
            return null;
        }
        int start = m.start();
        int end = m.end();
        int unmatchedPos = 0;
        int unmatchedCount = 0;
        for (int i = m.end(1); i < end; ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                if (unmatchedCount++ != 0) continue;
                unmatchedPos = i;
                continue;
            }
            if (c != ')' || unmatchedCount-- != 0) continue;
            return new TextRange(start, i);
        }
        if (unmatchedCount > 0) {
            return new TextRange(start, unmatchedPos);
        }
        return new TextRange(start, end);
    }

    @Nullable
    public static URL internProtocol(@NotNull URL url) {
        return UrlUtilRt.internProtocol(url);
    }

    @NotNull
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        return url == null ? "" : URLUtil.extractPath(url);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        int index = url.indexOf(SCHEME_SEPARATOR);
        return index >= 0 ? url.substring(index + SCHEME_SEPARATOR.length()) : url;
    }

    public static String encodePath(String path) {
        try {
            return new URI(null, null, path, null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            return path;
        }
    }

    public static String encodeQuery(String query) {
        try {
            return new URI(null, null, null, query, null).toASCIIString().substring(1);
        }
        catch (URISyntaxException e) {
            return query;
        }
    }
}

