/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.io.FilePageCache;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StorageLockContext {
    private static final FilePageCache ourDefaultCache = new FilePageCache();
    @NotNull
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    @NotNull
    private final FilePageCache myFilePageCache;
    private final boolean myUseReadWriteLock;
    private final boolean myCacheChannels;
    private final boolean myDisableAssertions;

    private StorageLockContext(@NotNull FilePageCache filePageCache, boolean useReadWriteLock, boolean cacheChannels, boolean disableAssertions) {
        this.myFilePageCache = filePageCache;
        this.myUseReadWriteLock = useReadWriteLock;
        this.myCacheChannels = cacheChannels;
        this.myDisableAssertions = disableAssertions;
    }

    public StorageLockContext(boolean useReadWriteLock, boolean cacheChannels) {
        this(ourDefaultCache, useReadWriteLock, cacheChannels, false);
    }

    public StorageLockContext(boolean useReadWriteLock, boolean cacheChannels, boolean disableAssertions) {
        this(ourDefaultCache, useReadWriteLock, cacheChannels, disableAssertions);
    }

    public StorageLockContext(boolean useReadWriteLock) {
        this(ourDefaultCache, useReadWriteLock, false, false);
    }

    public StorageLockContext() {
        this(ourDefaultCache, false, false, false);
    }

    boolean useChannelCache() {
        return this.myCacheChannels;
    }

    public Lock readLock() {
        return this.myUseReadWriteLock ? this.myLock.readLock() : this.myLock.writeLock();
    }

    public Lock writeLock() {
        return this.myLock.writeLock();
    }

    public void lockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().lock();
        } else {
            this.myLock.writeLock().lock();
        }
    }

    public void unlockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().unlock();
        } else {
            this.myLock.writeLock().unlock();
        }
    }

    public void lockWrite() {
        this.myLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.myLock.writeLock().unlock();
    }

    @ApiStatus.Internal
    @NotNull
    FilePageCache getBufferCache() {
        return this.myFilePageCache;
    }

    @ApiStatus.Internal
    public void checkWriteAccess() {
        if (!this.myDisableAssertions && IndexDebugProperties.DEBUG) {
            if (this.myLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock write lock to access PagedFileStorage");
        }
    }

    @ApiStatus.Internal
    public void checkReadAccess() {
        if (!this.myDisableAssertions && IndexDebugProperties.DEBUG) {
            if (this.myLock.getReadHoldCount() > 0 || this.myLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock read lock to access PagedFileStorage");
        }
    }

    void assertUnderSegmentAllocationLock() {
        if (IndexDebugProperties.DEBUG) {
            this.myFilePageCache.assertUnderSegmentAllocationLock();
        }
    }

    @ApiStatus.Internal
    public static void forceDirectMemoryCache() {
        ourDefaultCache.flushBuffers();
    }

    @ApiStatus.Internal
    @NotNull
    public static FilePageCacheStatistics getStatistics() {
        return ourDefaultCache.getStatistics();
    }

    @ApiStatus.Internal
    public static void assertNoBuffersLocked() {
        ourDefaultCache.assertNoBuffersLocked();
    }

    @ApiStatus.Internal
    public static long getCacheMaxSize() {
        return ourDefaultCache.getMaxSize();
    }
}

