/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapImpl;
import com.intellij.util.io.PersistentMapInMemory;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PersistentMapBuilder<Key, Value> {
    @NotNull
    private final Path myFile;
    @NotNull
    private final KeyDescriptor<Key> myKeyDescriptor;
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private Integer myInitialSize;
    private Integer myVersion;
    private StorageLockContext myLockContext;
    private Boolean myInlineValues;
    private Boolean myIsReadOnly;
    private Boolean myHasChunks;
    private Boolean myCompactOnClose = null;
    @NotNull
    private ExecutorService myWalExecutor = ConcurrencyUtil.newSameThreadExecutorService();
    private boolean myEnableWal;

    private PersistentMapBuilder(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) {
        this.myFile = file2;
        this.myKeyDescriptor = keyDescriptor;
        this.myValueExternalizer = valueExternalizer;
    }

    @NotNull
    public PersistentHashMap<Key, Value> build() throws IOException {
        return new PersistentHashMap<Key, Value>(this.buildImplementation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PersistentMapBase<Key, Value> buildImplementation() throws IOException {
        Boolean oldHasNoChunksValue = null;
        if (this.myHasChunks != null) {
            oldHasNoChunksValue = PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(this.myHasChunks == false);
        }
        Boolean previousReadOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
        PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(this.myIsReadOnly);
        try {
            if (SystemProperties.getBooleanProperty("idea.use.in.memory.persistent.map", false)) {
                PersistentMapInMemory persistentMapInMemory = new PersistentMapInMemory(this);
                return persistentMapInMemory;
            }
            PersistentMapImpl persistentMapImpl = new PersistentMapImpl(this);
            return persistentMapImpl;
        }
        finally {
            if (this.myHasChunks != null) {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(oldHasNoChunksValue);
            }
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(previousReadOnly);
        }
    }

    @NotNull
    public Path getFile() {
        return this.myFile;
    }

    @NotNull
    public KeyDescriptor<Key> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @NotNull
    public DataExternalizer<Value> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public static <Key, Value> PersistentMapBuilder<Key, Value> newBuilder(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) {
        return new PersistentMapBuilder<Key, Value>(file2, keyDescriptor, valueExternalizer);
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withInitialSize(int initialSize) {
        this.myInitialSize = initialSize;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withVersion(int version) {
        this.myVersion = version;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withReadonly(boolean readonly) {
        this.myIsReadOnly = readonly;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> readonly() {
        return this.withReadonly(true);
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withWal(boolean enableWal) {
        this.myEnableWal = enableWal;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> setWalExecutor(@NotNull ExecutorService service) {
        this.myWalExecutor = service;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> inlineValues(boolean inlineValues) {
        if (inlineValues && !(this.myValueExternalizer instanceof IntInlineKeyDescriptor)) {
            throw new IllegalStateException("can't inline values for externalizer " + this.myValueExternalizer.getClass());
        }
        this.myInlineValues = inlineValues;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> inlineValues() {
        return this.inlineValues(true);
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withStorageLockContext(@Nullable StorageLockContext context) {
        this.myLockContext = context;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> hasChunks(boolean hasChunks) {
        this.myHasChunks = hasChunks;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> hasNoChunks() {
        this.myHasChunks = false;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withCompactOnClose(boolean compactOnClose) {
        this.myCompactOnClose = compactOnClose;
        return this;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> compactOnClose() {
        return this.withCompactOnClose(true);
    }

    public int getInitialSize(int defaultValue) {
        if (this.myInitialSize != null) {
            return this.myInitialSize;
        }
        return defaultValue;
    }

    public int getVersion(int defaultValue) {
        if (this.myVersion != null) {
            return this.myVersion;
        }
        return defaultValue;
    }

    public boolean getInlineValues(boolean defaultValue) {
        if (this.myInlineValues != null) {
            return this.myInlineValues;
        }
        return defaultValue;
    }

    public boolean getReadOnly(boolean defaultValue) {
        if (this.myIsReadOnly != null) {
            return this.myIsReadOnly;
        }
        return defaultValue;
    }

    public boolean getCompactOnClose(boolean defaultCompactOnClose) {
        if (this.myCompactOnClose != null) {
            return this.myCompactOnClose;
        }
        return defaultCompactOnClose;
    }

    public boolean isEnableWal() {
        return this.myEnableWal;
    }

    public ExecutorService getWalExecutor() {
        return this.myWalExecutor;
    }

    @Nullable
    public StorageLockContext getLockContext() {
        return this.myLockContext;
    }
}

