/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.StorageLockContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMap<Key, Value>
implements AppendablePersistentMap<Key, Value>,
MeasurableIndexStore {
    @NonNls
    static String DATA_FILE_EXTENSION = ".values";
    @NotNull
    private final PersistentMapBase<Key, Value> myImpl;

    PersistentHashMap(@NotNull PersistentMapBuilder<Key, Value> builder, boolean checkInheritedMembers) throws IOException {
        if (checkInheritedMembers) {
            builder.withReadonly(false);
            builder.inlineValues(false);
        }
        this.myImpl = builder.build().myImpl;
    }

    public PersistentHashMap(@NotNull PersistentMapBase<Key, Value> impl) {
        this.myImpl = impl;
    }

    @Override
    public final void closeAndClean() throws IOException {
        this.myImpl.closeAndDelete();
    }

    public PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        this(PersistentMapBuilder.newBuilder(file2.toPath(), keyDescriptor, valueExternalizer), true);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        this(PersistentMapBuilder.newBuilder(file2, keyDescriptor, valueExternalizer), true);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        this(PersistentMapBuilder.newBuilder(file2, keyDescriptor, valueExternalizer).withInitialSize(initialSize), true);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version) throws IOException {
        this(PersistentMapBuilder.newBuilder(file2, keyDescriptor, valueExternalizer).withInitialSize(initialSize).withVersion(version), true);
    }

    public PersistentHashMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version, @Nullable StorageLockContext lockContext) throws IOException {
        this(PersistentMapBuilder.newBuilder(file2, keyDescriptor, valueExternalizer).withInitialSize(initialSize).withVersion(version).withStorageLockContext(lockContext), true);
    }

    public final void dropMemoryCaches() {
        this.force();
    }

    @Override
    public final void put(Key key, Value value) throws IOException {
        this.myImpl.put(key, value);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public final void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        this.myImpl.appendData(key, appender);
    }

    @Override
    public final void appendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        this.myImpl.appendData(key, appender);
    }

    @Override
    public final boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        return this.myImpl.processKeys(processor);
    }

    @Override
    public final boolean isClosed() {
        return this.myImpl.isClosed();
    }

    @Override
    public final boolean isDirty() {
        return this.myImpl.isDirty();
    }

    @Override
    public final void markDirty() throws IOException {
        this.myImpl.markDirty();
    }

    @Deprecated
    @NotNull
    public final Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList result = new ArrayList();
        this.myImpl.processExistingKeys(new CommonProcessors.CollectProcessor(result));
        return result;
    }

    public final boolean processKeysWithExistingMapping(@NotNull Processor<? super Key> processor) throws IOException {
        return this.myImpl.processExistingKeys(processor);
    }

    @Override
    public final Value get(Key key) throws IOException {
        return this.myImpl.get(key);
    }

    @Override
    public final boolean containsMapping(Key key) throws IOException {
        return this.myImpl.containsKey(key);
    }

    @Override
    public final void remove(Key key) throws IOException {
        this.myImpl.remove(key);
    }

    @Override
    public final void force() {
        try {
            this.myImpl.force();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int keysCountApproximately() {
        return this.myImpl.keysCount();
    }

    @Override
    public final void close() throws IOException {
        this.myImpl.close();
    }

    public final String toString() {
        return this.myImpl.toString();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static interface ValueDataAppender
    extends AppendablePersistentMap.ValueDataAppender {
    }
}

