/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.util.Processor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEnumerator<Data>
implements ScannableDataEnumeratorEx<Data>,
Closeable,
Forceable {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        this(file2, dataDescriptor, initialSize, null);
    }

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        this.myEnumerator = new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext);
    }

    public PersistentEnumerator(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        this(file2.toPath(), dataDescriptor, initialSize, lockContext, version);
    }

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        this.myEnumerator = PersistentEnumerator.createDefaultEnumerator(file2, dataDescriptor, initialSize, lockContext, version, true);
    }

    @NotNull
    static <Data> PersistentEnumeratorBase<Data> createDefaultEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version, boolean registerForStats) throws IOException {
        return new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext, version, false, registerForStats);
    }

    @ApiStatus.Internal
    public static int getVersion() {
        return PersistentBTreeEnumerator.baseVersion();
    }

    @Override
    public void close() throws IOException {
        PersistentEnumeratorBase<Data> enumerator = this.myEnumerator;
        if (enumerator != null) {
            enumerator.close();
        }
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    public final void markDirty() throws IOException {
        Lock lock = this.myEnumerator.getWriteLock();
        lock.lock();
        try {
            this.myEnumerator.markDirty(true);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }

    @Override
    public void force() {
        this.myEnumerator.force();
    }

    @Override
    public Data valueOf(int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    @Override
    public int enumerate(Data name) throws IOException {
        return this.myEnumerator.enumerate(name);
    }

    @Override
    public int tryEnumerate(Data name) throws IOException {
        return this.myEnumerator.tryEnumerate(name);
    }

    @ApiStatus.Internal
    public Collection<Data> getAllDataObjects(@Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        return this.myEnumerator.getAllDataObjects(filter);
    }

    @Override
    @ApiStatus.Internal
    public boolean processAllDataObjects(@NotNull Processor<? super Data> processor) throws IOException {
        return this.myEnumerator.iterateData(processor);
    }
}

