/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.EnumeratorCharSequenceDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentCharSequenceEnumerator
extends PersistentEnumerator<CharSequence> {
    @Nullable
    private final CachingEnumerator<CharSequence> myCache;

    public PersistentCharSequenceEnumerator(@NotNull Path file2) throws IOException {
        this(file2, null);
    }

    public PersistentCharSequenceEnumerator(@NotNull Path file2, @Nullable StorageLockContext storageLockContext) throws IOException {
        this(file2, 4096, storageLockContext);
    }

    public PersistentCharSequenceEnumerator(@NotNull Path file2, boolean cacheLastMappings) throws IOException {
        this(file2, 4096, cacheLastMappings, null);
    }

    public PersistentCharSequenceEnumerator(@NotNull Path file2, int initialSize) throws IOException {
        this(file2, initialSize, null);
    }

    public PersistentCharSequenceEnumerator(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        this(file2, initialSize, false, lockContext);
    }

    public PersistentCharSequenceEnumerator(@NotNull Path file2, int initialSize, boolean cacheLastMappings, @Nullable StorageLockContext lockContext) throws IOException {
        super(file2, EnumeratorCharSequenceDescriptor.INSTANCE, initialSize, lockContext);
        this.myCache = cacheLastMappings ? new CachingEnumerator<CharSequence>(new DataEnumerator<CharSequence>(){

            @Override
            public int enumerate(@Nullable CharSequence value) throws IOException {
                return PersistentCharSequenceEnumerator.super.enumerate(value);
            }

            @Override
            @Nullable
            public CharSequence valueOf(int idx) throws IOException {
                return (CharSequence)PersistentCharSequenceEnumerator.super.valueOf(idx);
            }
        }, EnumeratorCharSequenceDescriptor.INSTANCE) : null;
    }

    @Override
    public int enumerate(@Nullable CharSequence value) throws IOException {
        return this.myCache != null ? this.myCache.enumerate(value) : super.enumerate(value);
    }

    @Override
    @Nullable
    public CharSequence valueOf(int idx) throws IOException {
        return this.myCache != null ? this.myCache.valueOf(idx) : (CharSequence)super.valueOf(idx);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myCache != null) {
            this.myCache.close();
        }
    }
}

