/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.UnInterruptibleFileChannel;
import com.intellij.util.io.stats.CachedChannelsStatistics;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class OpenChannelsCache {
    private final int myCapacity;
    private int myHitCount;
    private int myMissCount;
    private int myLoadCount;
    @NotNull
    private final Map<Path, ChannelDescriptor> myCache;
    private final Object myLock = new Object();

    OpenChannelsCache(int capacity) {
        this.myCapacity = capacity;
        this.myCache = new LinkedHashMap<Path, ChannelDescriptor>(capacity, 0.5f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    CachedChannelsStatistics getStatistics() {
        Object object = this.myLock;
        synchronized (object) {
            return new CachedChannelsStatistics(this.myHitCount, this.myMissCount, this.myLoadCount, this.myCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T useChannel(@NotNull Path path, @NotNull ChannelProcessor<T> processor, boolean read) throws IOException {
        ChannelDescriptor descriptor;
        Object object = this.myLock;
        synchronized (object) {
            descriptor = this.myCache.get(path);
            if (descriptor == null) {
                boolean somethingDropped = this.releaseOverCachedChannels();
                descriptor = new ChannelDescriptor(path, read);
                this.myCache.put(path, descriptor);
                if (somethingDropped) {
                    ++this.myMissCount;
                } else {
                    ++this.myLoadCount;
                }
            } else if (!read && descriptor.isReadOnly()) {
                if (descriptor.isLocked()) {
                    descriptor = new ChannelDescriptor(path, false);
                } else {
                    this.closeChannel(path);
                    descriptor = new ChannelDescriptor(path, false);
                    this.myCache.put(path, descriptor);
                }
                ++this.myMissCount;
            } else {
                ++this.myHitCount;
            }
            descriptor.lock();
        }
        try {
            object = processor.process(descriptor.getChannel());
            return (T)object;
        }
        finally {
            Object object2 = this.myLock;
            synchronized (object2) {
                descriptor.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeChannel(Path path) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            ChannelDescriptor descriptor = this.myCache.remove(path);
            if (descriptor != null) {
                assert (!descriptor.isLocked());
                descriptor.close();
            }
        }
    }

    private boolean releaseOverCachedChannels() throws IOException {
        int dropCount = this.myCache.size() - this.myCapacity;
        if (dropCount >= 0) {
            ArrayList<Path> keysToDrop = new ArrayList<Path>();
            for (Map.Entry<Path, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (Path file2 : keysToDrop) {
                this.closeChannel(file2);
            }
            return true;
        }
        return false;
    }

    static final class ChannelDescriptor
    implements Closeable {
        private int myLockCount = 0;
        @NotNull
        private final UnInterruptibleFileChannel myChannel;
        private final boolean myReadOnly;
        private static final OpenOption[] MODIFIABLE_OPTS = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        private static final OpenOption[] READ_ONLY_OPTS = new OpenOption[]{StandardOpenOption.READ};

        ChannelDescriptor(@NotNull Path file2, boolean readOnly) throws IOException {
            this.myReadOnly = readOnly;
            this.myChannel = Objects.requireNonNull((UnInterruptibleFileChannel)FileUtilRt.doIOOperation(lastAttempt -> {
                try {
                    return new UnInterruptibleFileChannel(file2, readOnly ? READ_ONLY_OPTS : MODIFIABLE_OPTS);
                }
                catch (NoSuchFileException ex) {
                    Path parent = file2.getParent();
                    if (!readOnly) {
                        if (!Files.exists(parent, new LinkOption[0])) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        if (!lastAttempt) {
                            return null;
                        }
                    }
                    throw ex;
                }
            }));
        }

        boolean isReadOnly() {
            return this.myReadOnly;
        }

        void lock() {
            ++this.myLockCount;
        }

        void unlock() {
            --this.myLockCount;
        }

        boolean isLocked() {
            return this.myLockCount != 0;
        }

        @NotNull
        UnInterruptibleFileChannel getChannel() {
            return this.myChannel;
        }

        @Override
        public void close() throws IOException {
            this.myChannel.close();
        }
    }

    @FunctionalInterface
    static interface ChannelProcessor<T> {
        public T process(@NotNull FileChannel var1) throws IOException;
    }
}

