/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.containers.hash.LongLinkedHashMap;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.system.CpuArch;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FilePageCache {
    private static final Logger LOG = Logger.getInstance(FilePageCache.class);
    static final long MAX_PAGES_COUNT = 0xFFFFFFFFL;
    private static final long FILE_INDEX_MASK = -4294967296L;
    private static final int CACHE_SIZE;
    static final int ALLOCATOR_SIZE;
    static final int DEFAULT_PAGE_SIZE;
    private final Int2ObjectMap<PagedFileStorage> storageById = new Int2ObjectOpenHashMap();
    private final ReentrantLock pagesAccessLock = new ReentrantLock();
    private final ReentrantLock pagesAllocationLock = new ReentrantLock();
    private final LongLinkedHashMap<DirectBufferWrapper> pagesByPageId;
    private final LinkedHashMap<Long, DirectBufferWrapper> pagesToRemoveByPageId = new LinkedHashMap();
    private final long cachedSizeLimit = CACHE_SIZE;
    private long totalSizeCached;
    private volatile int myUncachedFileAccess;
    private int myFastCacheHits;
    private int myHits;
    private int myMisses;
    private int myLoad;
    private long myMaxLoadedSize;
    private volatile int myMaxRegisteredFiles;
    private volatile int myMappingChangeCount;
    private long myCreatedCount;
    private long myCreatedMs;
    private long myDisposalMs;

    FilePageCache() {
        this.pagesByPageId = new LongLinkedHashMap<DirectBufferWrapper>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(LongLinkedHashMap.Entry<DirectBufferWrapper> eldest) {
                assert (FilePageCache.this.pagesAccessLock.isHeldByCurrentThread());
                return FilePageCache.this.totalSizeCached > FilePageCache.this.cachedSizeLimit;
            }

            @Override
            public DirectBufferWrapper put(long key, @NotNull DirectBufferWrapper wrapper) {
                FilePageCache.this.totalSizeCached += wrapper.getLength();
                DirectBufferWrapper oldShouldBeNull = super.put(key, wrapper);
                FilePageCache.this.myMaxLoadedSize = Math.max(FilePageCache.this.myMaxLoadedSize, FilePageCache.this.totalSizeCached);
                return oldShouldBeNull;
            }

            @Override
            @Nullable
            public DirectBufferWrapper remove(long key) {
                assert (FilePageCache.this.pagesAccessLock.isHeldByCurrentThread());
                DirectBufferWrapper wrapper = (DirectBufferWrapper)super.remove(key);
                if (wrapper != null) {
                    ++FilePageCache.this.myMappingChangeCount;
                    FilePageCache.this.pagesToRemoveByPageId.put((Object)key, (Object)wrapper);
                    FilePageCache.this.totalSizeCached -= wrapper.getLength();
                }
                return wrapper;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectBufferWrapper get(long pageId, boolean read, boolean checkAccess) throws IOException {
        DirectBufferWrapper wrapper;
        this.pagesAccessLock.lock();
        try {
            wrapper = this.pagesByPageId.get(pageId);
            if (wrapper != null) {
                ++this.myHits;
                DirectBufferWrapper directBufferWrapper = wrapper;
                return directBufferWrapper;
            }
        }
        finally {
            this.pagesAccessLock.unlock();
        }
        this.pagesAllocationLock.lock();
        try {
            DirectBufferWrapper notYetRemoved = (DirectBufferWrapper)this.pagesToRemoveByPageId.remove((Object)pageId);
            if (notYetRemoved != null) {
                DirectBufferWrapper previous;
                this.pagesAccessLock.lock();
                try {
                    previous = this.pagesByPageId.put(pageId, notYetRemoved);
                    assert (previous == null);
                }
                finally {
                    this.pagesAccessLock.unlock();
                }
                this.disposeRemovedSegments(null);
                ++this.myHits;
                previous = notYetRemoved;
                return previous;
            }
            this.pagesAccessLock.lock();
            try {
                wrapper = this.pagesByPageId.get(pageId);
                if (wrapper != null) {
                    DirectBufferWrapper previous = wrapper;
                    return previous;
                }
            }
            finally {
                this.pagesAccessLock.unlock();
            }
            long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            PagedFileStorage fileStorage = this.getRegisteredPagedFileStorageByIndex(pageId);
            this.disposeRemovedSegments(null);
            long disposed = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            wrapper = FilePageCache.allocateAndLoadPage(pageId, read, fileStorage, checkAccess);
            if (IOStatistics.DEBUG) {
                long finished = System.currentTimeMillis();
                ++this.myCreatedCount;
                this.myCreatedMs += finished - disposed;
                this.myDisposalMs += disposed - started;
            }
            this.pagesAccessLock.lock();
            try {
                if (this.totalSizeCached + (long)fileStorage.myPageSize < this.cachedSizeLimit) {
                    ++this.myLoad;
                } else {
                    ++this.myMisses;
                }
                this.pagesByPageId.put(pageId, wrapper);
            }
            finally {
                this.pagesAccessLock.unlock();
            }
            this.ensureSize(this.cachedSizeLimit);
            DirectBufferWrapper directBufferWrapper = wrapper;
            return directBufferWrapper;
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    public void incrementUncachedFileAccess() {
        ++this.myUncachedFileAccess;
    }

    public void incrementFastCacheHitsCount() {
        ++this.myFastCacheHits;
    }

    public long getMaxSize() {
        return this.cachedSizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmapBuffersForOwner(PagedFileStorage fileStorage) {
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(fileStorage);
        if (!buffers.isEmpty()) {
            this.pagesAccessLock.lock();
            try {
                for (Long key : buffers.keySet()) {
                    this.pagesByPageId.remove(key);
                }
            }
            finally {
                this.pagesAccessLock.unlock();
            }
        }
        this.pagesAllocationLock.lock();
        try {
            this.disposeRemovedSegments(fileStorage);
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    void flushBuffers() {
        this.pagesAccessLock.lock();
        try {
            while (!this.pagesByPageId.isEmpty()) {
                this.pagesByPageId.doRemoveEldestEntry();
            }
        }
        finally {
            this.pagesAccessLock.unlock();
        }
        this.pagesAllocationLock.lock();
        try {
            this.disposeRemovedSegments(null);
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffersForOwner(PagedFileStorage storage) throws IOException {
        storage.getStorageLockContext().checkReadAccess();
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(storage);
        if (!buffers.isEmpty()) {
            SmartList<IOException> exceptions = new SmartList<IOException>();
            this.pagesAllocationLock.lock();
            try {
                try {
                    for (DirectBufferWrapper buffer : buffers.values()) {
                        if (!buffer.isDirty() || buffer.isReleased()) continue;
                        buffer.force();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            finally {
                this.pagesAllocationLock.unlock();
            }
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStorage(long storageId) {
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.storageById;
        synchronized (int2ObjectMap) {
            this.storageById.remove((int)(storageId >> 32));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoBuffersLocked() {
        this.pagesAllocationLock.lock();
        try {
            this.pagesAccessLock.lock();
            try {
                for (DirectBufferWrapper value : this.pagesByPageId.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
                for (DirectBufferWrapper value : this.pagesToRemoveByPageId.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
            }
            finally {
                this.pagesAccessLock.unlock();
            }
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    void assertUnderSegmentAllocationLock() {
        assert (this.pagesAllocationLock.isHeldByCurrentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long registerPagedFileStorage(@NotNull PagedFileStorage storage) {
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.storageById;
        synchronized (int2ObjectMap) {
            int storageIndex = this.storageById.size();
            while (this.storageById.get(storageIndex) != null) {
                ++storageIndex;
            }
            this.storageById.put(storageIndex, (Object)storage);
            this.myMaxRegisteredFiles = Math.max(this.myMaxRegisteredFiles, this.storageById.size());
            return (long)storageIndex << 32;
        }
    }

    @NotNull
    FilePageCacheStatistics getStatistics() {
        this.pagesAllocationLock.lock();
        try {
            this.pagesAccessLock.lock();
            try {
                FilePageCacheStatistics filePageCacheStatistics = new FilePageCacheStatistics(PagedFileStorage.CHANNELS_CACHE.getStatistics(), this.myUncachedFileAccess, this.myMaxRegisteredFiles, this.myMaxLoadedSize, this.myHits, this.myFastCacheHits, this.myMisses, this.myLoad, this.myMappingChangeCount, this.cachedSizeLimit);
                this.pagesAccessLock.unlock();
                return filePageCacheStatistics;
            }
            catch (Throwable throwable) {
                this.pagesAccessLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("jdk.internal.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("sun.misc.VM");
                Method maxDirectMemory = aClass2.getMethod("maxDirectMemory", new Class[0]);
                return (Long)maxDirectMemory.invoke(null, new Object[0]);
            }
            catch (Throwable aClass2) {
                try {
                    Class<?> aClass3 = Class.forName("java.nio.Bits");
                    Field maxMemory = aClass3.getDeclaredField("maxMemory");
                    maxMemory.setAccessible(true);
                    return (Long)maxMemory.get(null);
                }
                catch (Throwable aClass3) {
                    try {
                        Class<?> aClass4 = Class.forName("java.nio.Bits");
                        Field maxMemory = aClass4.getDeclaredField("MAX_MEMORY");
                        maxMemory.setAccessible(true);
                        return (Long)maxMemory.get(null);
                    }
                    catch (Throwable throwable) {
                        return Runtime.getRuntime().maxMemory();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull(value="Seems accessed storage has been closed")
    private @NotNull(value="Seems accessed storage has been closed") PagedFileStorage getRegisteredPagedFileStorageByIndex(long storageId) {
        int storageIndex = (int)((storageId & 0xFFFFFFFF00000000L) >> 32);
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.storageById;
        synchronized (int2ObjectMap) {
            return (PagedFileStorage)this.storageById.get(storageIndex);
        }
    }

    private void disposeRemovedSegments(@Nullable PagedFileStorage verificationStorage) {
        this.assertUnderSegmentAllocationLock();
        if (this.pagesToRemoveByPageId.isEmpty()) {
            return;
        }
        Iterator iterator = this.pagesToRemoveByPageId.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)iterator.next();
                DirectBufferWrapper wrapper = (DirectBufferWrapper)entry.getValue();
                boolean released = wrapper.tryRelease(wrapper.getFile() == verificationStorage);
                if (!released) continue;
                iterator.remove();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void ensureSize(long sizeLimit) {
        this.pagesAllocationLock.isHeldByCurrentThread();
        this.pagesAccessLock.lock();
        try {
            while (this.totalSizeCached > sizeLimit) {
                this.pagesByPageId.doRemoveEldestEntry();
            }
        }
        finally {
            this.pagesAccessLock.unlock();
        }
        this.disposeRemovedSegments(null);
    }

    @NotNull
    private static DirectBufferWrapper allocateAndLoadPage(long pageId, boolean read, PagedFileStorage owner, boolean checkAccess) throws IOException {
        if (checkAccess) {
            StorageLockContext context = owner.getStorageLockContext();
            if (read) {
                context.checkReadAccess();
            } else {
                context.checkWriteAccess();
            }
        }
        long offsetInFile = (pageId & 0xFFFFFFFFL) * (long)owner.myPageSize;
        return new DirectBufferWrapper(owner, offsetInFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Long, DirectBufferWrapper> getBuffersForOwner(@NotNull PagedFileStorage storage) {
        StorageLockContext storageLockContext = storage.getStorageLockContext();
        this.pagesAccessLock.lock();
        try {
            storageLockContext.checkReadAccess();
            TreeMap<Long, DirectBufferWrapper> mineBuffers = new TreeMap<Long, DirectBufferWrapper>();
            for (LongLinkedHashMap.Entry<DirectBufferWrapper> entry : this.pagesByPageId.entrySet()) {
                if (entry.getValue().getFile() != storage) continue;
                mineBuffers.put(entry.getKey(), entry.getValue());
            }
            TreeMap<Long, DirectBufferWrapper> treeMap = mineBuffers;
            return treeMap;
        }
        finally {
            this.pagesAccessLock.unlock();
        }
    }

    static {
        int defaultPageSizeMb = SystemProperties.getIntProperty("idea.paged.storage.page.size", 10);
        DEFAULT_PAGE_SIZE = Math.max(1, defaultPageSizeMb) * 0x100000;
        int lowerCacheSizeMb = 100;
        int upperCacheSizeMb = CpuArch.is32Bit() ? 200 : 500;
        long maxDirectMemoryToUse = FilePageCache.maxDirectMemory() - 2L * (long)DEFAULT_PAGE_SIZE;
        int lowerLimit = (int)Math.min(0x6400000L, maxDirectMemoryToUse);
        int cacheSizeMb = SystemProperties.getIntProperty("idea.max.paged.storage.cache", upperCacheSizeMb);
        CACHE_SIZE = (int)Math.min((long)Math.max(lowerLimit, cacheSizeMb * 0x100000), maxDirectMemoryToUse);
        ALLOCATOR_SIZE = (int)Math.min(0x6400000L, Math.max(0L, maxDirectMemoryToUse - (long)CACHE_SIZE - 314572800L));
    }
}

