/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.FilePageCache;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferAllocator {
    private static final ExecutorService ourAllocator = SystemInfoRt.isLinux && Boolean.parseBoolean(System.getProperty("idea.limit.paged.storage.allocators", "true")) ? ConcurrencyUtil.newSingleThreadExecutor("DirectBufferWrapper allocation thread") : null;
    private static final boolean USE_POOLED_ALLOCATOR = SystemProperties.getBooleanProperty("idea.index.use.pooled.page.allocator", true);
    private final ConcurrentSkipListMap<Integer, ArrayBlockingQueue<ByteBuffer>> myPool = new ConcurrentSkipListMap();
    private final AtomicInteger mySize = new AtomicInteger();
    private final int mySizeLimitInBytes;
    private static final boolean dumpStats = false;
    private static volatile int hit;
    private static volatile int miss;
    private static volatile int reused;
    private static volatile int disposed;
    public static final DirectByteBufferAllocator ALLOCATOR;

    static <E extends Exception> ByteBuffer allocate(ThrowableComputable<? extends ByteBuffer, E> computable) throws E {
        if (ourAllocator != null) {
            try {
                return ourAllocator.submit(() -> computable.compute()).get();
            }
            catch (InterruptedException e) {
                Logger.getInstance(DirectByteBufferAllocator.class).error(e);
                return (ByteBuffer)computable.compute();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                throw new RuntimeException(e);
            }
        }
        return (ByteBuffer)computable.compute();
    }

    private DirectByteBufferAllocator(int sizeLimitInBytes) {
        this.mySizeLimitInBytes = sizeLimitInBytes;
    }

    DirectByteBufferAllocator() {
        this(FilePageCache.ALLOCATOR_SIZE);
    }

    @NotNull
    public ByteBuffer allocate(int size) {
        if (USE_POOLED_ALLOCATOR) {
            Map.Entry<Integer, ArrayBlockingQueue<ByteBuffer>> buffers = this.myPool.ceilingEntry(size);
            while (buffers != null) {
                ByteBuffer cachedBuffer = buffers.getValue().poll();
                int capacity = buffers.getKey();
                if (cachedBuffer != null) {
                    cachedBuffer.rewind();
                    cachedBuffer.limit(size);
                    this.mySize.addAndGet(-capacity);
                    return cachedBuffer;
                }
                buffers = this.myPool.higherEntry(capacity);
            }
        }
        return DirectByteBufferAllocator.allocateNewBuffer(size);
    }

    private static ByteBuffer allocateNewBuffer(int size) {
        return DirectByteBufferAllocator.allocate(() -> ByteBuffer.allocateDirect(size));
    }

    public void release(@NotNull ByteBuffer buffer) {
        int capacity;
        if (USE_POOLED_ALLOCATOR && this.mySize.get() < this.mySizeLimitInBytes && this.myPool.computeIfAbsent(capacity = buffer.capacity(), __ -> new ArrayBlockingQueue(40)).offer(buffer)) {
            this.mySize.addAndGet(capacity);
            return;
        }
        ByteBufferUtil.cleanBuffer(buffer);
    }

    private static /* synthetic */ void lambda$static$0() {
        System.out.println("pooled buffer stats: hits = " + hit + ", miss = " + miss + ", reused = " + reused + ", disposed = " + disposed);
    }

    static {
        ALLOCATOR = new DirectByteBufferAllocator();
    }
}

