/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectBufferWrapper {
    private static final int RELEASED_CODE = -1;
    private static final AtomicIntegerFieldUpdater<DirectBufferWrapper> REF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DirectBufferWrapper.class, "myReferences");
    @NotNull
    private final PagedFileStorage myFile;
    private volatile ByteBuffer myBuffer;
    private final long myPosition;
    private volatile int myBufferDataEndPos;
    private volatile boolean myDirty;
    private volatile int myReferences = 0;

    DirectBufferWrapper(@NotNull PagedFileStorage file2, long positionInFile) throws IOException {
        file2.getStorageLockContext().assertUnderSegmentAllocationLock();
        this.myFile = file2;
        this.myPosition = positionInFile;
        this.myBuffer = this.allocateAndLoadFileContent();
    }

    public ByteBuffer getBuffer() {
        return this.myBuffer;
    }

    public void markDirty() throws IOException {
        if (!this.myDirty) {
            if (this.myFile.isReadOnly()) {
                throw new IOException("Read-only byte buffer can't be modified. File: " + this.myFile);
            }
            this.myDirty = true;
            this.myFile.markDirty();
        }
    }

    public void fileSizeMayChanged(int bufferDataEndPos) {
        if (bufferDataEndPos > this.myBufferDataEndPos) {
            this.myBufferDataEndPos = bufferDataEndPos;
            this.myFile.ensureCachedSizeAtLeast(this.myPosition + (long)this.myBufferDataEndPos);
        }
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public ByteBuffer copy() {
        return DirectByteBufferAllocator.allocate(() -> {
            ByteBuffer duplicate = this.myBuffer.duplicate();
            duplicate.order(this.myBuffer.order());
            return duplicate;
        });
    }

    public byte get(int index, boolean checkAccess) {
        if (checkAccess) {
            StorageLockContext context = this.myFile.getStorageLockContext();
            context.checkReadAccess();
        }
        return this.myBuffer.get(index);
    }

    public long getLong(int index) {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkReadAccess();
        return this.myBuffer.getLong(index);
    }

    public void putLong(int index, long value) throws IOException {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.markDirty();
        this.myBuffer.putLong(index, value);
        this.fileSizeMayChanged(index + 8);
    }

    public int getInt(int index) {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkReadAccess();
        return this.myBuffer.getInt(index);
    }

    public void putInt(int index, int value) throws IOException {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.markDirty();
        this.myBuffer.putInt(index, value);
        this.fileSizeMayChanged(index + 4);
    }

    public void position(int newPosition) {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.myBuffer.position(newPosition);
    }

    public int position() {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkReadAccess();
        return this.myBuffer.position();
    }

    public void put(ByteBuffer src) throws IOException {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(src);
        this.fileSizeMayChanged(this.myBuffer.position());
    }

    public void put(int index, byte b) throws IOException {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(index, b);
        this.fileSizeMayChanged(index + 1);
    }

    public void readToArray(byte[] dst, int o, int page_offset, int page_len, boolean checkAccess) throws IllegalArgumentException {
        if (checkAccess) {
            StorageLockContext context = this.myFile.getStorageLockContext();
            context.checkReadAccess();
        }
        ByteBufferUtil.copyMemory(this.myBuffer, page_offset, dst, o, page_len);
    }

    public void putFromArray(byte[] src, int o, int page_offset, int page_len) throws IOException, IllegalArgumentException {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.markDirty();
        ByteBuffer buf = this.myBuffer.duplicate();
        buf.position(page_offset);
        buf.put(src, o, page_len);
        this.fileSizeMayChanged(buf.position());
    }

    public void putFromBuffer(@NotNull ByteBuffer data, int page_offset) throws IOException, IllegalArgumentException {
        StorageLockContext context = this.myFile.getStorageLockContext();
        context.checkWriteAccess();
        this.markDirty();
        ByteBuffer buf = this.myBuffer.duplicate();
        buf.position(page_offset);
        buf.put(data);
        this.fileSizeMayChanged(buf.position());
    }

    public boolean tryLock() {
        return REF_UPDATER.updateAndGet(this, refCount -> refCount >= 0 ? refCount + 1 : refCount) >= 0;
    }

    public void unlock() {
        int currentRefs = REF_UPDATER.decrementAndGet(this);
        assert (currentRefs >= 0);
    }

    public boolean isReleased() {
        return this.myReferences == -1;
    }

    public boolean isLocked() {
        return this.myReferences > 0;
    }

    public int getLength() {
        return this.myFile.myPageSize;
    }

    private ByteBuffer allocateAndLoadFileContent() throws IOException {
        int bufferSize = this.myFile.myPageSize;
        ByteBuffer buffer = DirectByteBufferAllocator.ALLOCATOR.allocate(bufferSize);
        buffer.order(this.myFile.useNativeByteOrder() ? ByteOrder.nativeOrder() : ByteOrder.BIG_ENDIAN);
        assert (buffer.limit() > 0);
        return this.myFile.useChannel(ch -> {
            int readBytes = ch.read(buffer, this.myPosition);
            if (readBytes < bufferSize) {
                for (int i = Math.max(0, readBytes); i < bufferSize; ++i) {
                    buffer.put(i, (byte)0);
                }
            }
            return buffer;
        }, this.myFile.isReadOnly());
    }

    boolean tryRelease(boolean force) throws IOException {
        boolean releaseState;
        boolean bl = releaseState = REF_UPDATER.updateAndGet(this, operand -> operand == 0 ? -1 : operand) == -1;
        if (releaseState || force) {
            this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
            if (this.isDirty()) {
                this.force();
            }
            if (this.myBuffer != null) {
                DirectByteBufferAllocator.ALLOCATOR.release(this.myBuffer);
                this.myBuffer = null;
            }
            if (force && !releaseState) {
                PagedFileStorage.LOG.error("Page buffer is referenced but was forcibly released for file " + this.myFile.getFile());
            }
            return true;
        }
        return false;
    }

    void force() throws IOException {
        this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
        assert (!this.myFile.isReadOnly());
        if (this.isDirty()) {
            ByteBuffer buffer = this.myBuffer.duplicate();
            buffer.rewind();
            buffer.limit(this.myBufferDataEndPos);
            this.myFile.useChannel(ch -> {
                ch.write(buffer, this.myPosition);
                return null;
            }, this.myFile.isReadOnly());
            this.myDirty = false;
        }
    }

    @NotNull
    PagedFileStorage getFile() {
        return this.myFile;
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myFile.myPageSize;
    }
}

