/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u001bH\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007J\"\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020!H\u0007J\"\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010+\u001a\u00020!H\u0007J\f\u0010,\u001a\u00020\u0004*\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R!\u0010\t\u001a\u00020\n8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\b\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006R\u001b\u0010\u0012\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0013\u0010\u0006R\u001b\u0010\u0015\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0016\u0010\u0006R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/util/io/DigestUtil;", "", "()V", "md5", "Ljava/security/MessageDigest;", "getMd5", "()Ljava/security/MessageDigest;", "md5$delegate", "Lkotlin/Lazy;", "random", "Ljava/security/SecureRandom;", "getRandom$annotations", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "sha1", "getSha1", "sha1$delegate", "sha256", "getSha256", "sha256$delegate", "sha512", "getSha512", "sha512$delegate", "sunSecurityProvider", "Ljava/security/Provider;", "digestToHash", "", "digest", "getMessageDigest", "algorithm", "md5Hex", "input", "", "randomToken", "sha1Hex", "sha256Hex", "file", "Ljava/nio/file/Path;", "updateContentHash", "", "inputStream", "Ljava/io/InputStream;", "buffer", "cloneDigest", "intellij.platform.util"})
public final class DigestUtil {
    @NotNull
    public static final DigestUtil INSTANCE = new DigestUtil();
    @NotNull
    private static final Provider sunSecurityProvider;
    @NotNull
    private static final Lazy random$delegate;
    @NotNull
    private static final Lazy md5$delegate;
    @NotNull
    private static final Lazy sha1$delegate;
    @NotNull
    private static final Lazy sha256$delegate;
    @NotNull
    private static final Lazy sha512$delegate;

    private DigestUtil() {
    }

    @NotNull
    public static final SecureRandom getRandom() {
        Lazy lazy = random$delegate;
        return (SecureRandom)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getRandom$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String randomToken() {
        String string2 = new BigInteger(130, INSTANCE.getRandom()).toString(32);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BigInteger(130, random).toString(32)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest md5() {
        return INSTANCE.cloneDigest(INSTANCE.getMd5());
    }

    private final MessageDigest getMd5() {
        Lazy lazy = md5$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha1() {
        return INSTANCE.cloneDigest(INSTANCE.getSha1());
    }

    private final MessageDigest getSha1() {
        Lazy lazy = sha1$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha256() {
        return INSTANCE.cloneDigest(INSTANCE.getSha256());
    }

    private final MessageDigest getSha256() {
        Lazy lazy = sha256$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha512() {
        return INSTANCE.cloneDigest(INSTANCE.getSha512());
    }

    private final MessageDigest getSha512() {
        Lazy lazy = sha512$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final String digestToHash(@NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
        return DigestUtilKt.access$bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String sha256Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] byArray = INSTANCE.sha256().digest(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha256().digest(input)");
        return DigestUtilKt.access$bytesToHex(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String sha256Hex(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        try {
            MessageDigest digest = INSTANCE.sha256();
            byte[] buffer = new byte[524288];
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(file2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                DigestUtil.updateContentHash(digest, it, buffer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
            return DigestUtilKt.access$bytesToHex(byArray);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + file2 + ". " + e.getMessage(), e);
        }
    }

    @JvmStatic
    @NotNull
    public static final String sha1Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] byArray = INSTANCE.sha1().digest(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha1().digest(input)");
        return DigestUtilKt.access$bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String md5Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] byArray = INSTANCE.md5().digest(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md5().digest(input)");
        return DigestUtilKt.access$bytesToHex(byArray);
    }

    private final MessageDigest cloneDigest(MessageDigest $this$cloneDigest) {
        MessageDigest messageDigest;
        try {
            Object object = $this$cloneDigest.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.MessageDigest");
            messageDigest = (MessageDigest)object;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Message digest is not cloneable: " + $this$cloneDigest);
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path file2, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(file2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                DigestUtil.updateContentHash(digest, it, buffer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + file2 + ". " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ void updateContentHash$default(MessageDigest messageDigest, Path path, byte[] byArray, int n, Object object) {
        if ((n & 4) != 0) {
            byArray = new byte[524288];
        }
        DigestUtil.updateContentHash(messageDigest, path, byArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull InputStream inputStream, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            int sz;
            while ((sz = inputStream.read(buffer)) > 0) {
                digest.update(buffer, 0, sz);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read stream. " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ void updateContentHash$default(MessageDigest messageDigest, InputStream inputStream, byte[] byArray, int n, Object object) {
        if ((n & 4) != 0) {
            byArray = new byte[524288];
        }
        DigestUtil.updateContentHash(messageDigest, inputStream, byArray);
    }

    private final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(algorithm, sunSecurityProvider)");
        return messageDigest;
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        DigestUtil.updateContentHash$default(digest, file2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        DigestUtil.updateContentHash$default(digest, inputStream, null, 4, null);
    }

    public static final /* synthetic */ MessageDigest access$getMessageDigest(DigestUtil $this, String algorithm) {
        return $this.getMessageDigest(algorithm);
    }

    static {
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"getProvider(\"SUN\")");
        sunSecurityProvider = provider;
        random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
        md5$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)md5.2.INSTANCE);
        sha1$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)sha1.2.INSTANCE);
        sha256$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)sha256.2.INSTANCE);
        sha512$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)sha512.2.INSTANCE);
    }
}

