/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CountingInputStream
extends FilterInputStream {
    private long myBytesRead = 0L;
    private long myMark = -1L;

    public CountingInputStream(@NotNull InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.in.read();
        if (bytesRead != -1) {
            ++this.myBytesRead;
        }
        return bytesRead;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead != -1) {
            this.myBytesRead += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = this.in.skip(n);
        this.myBytesRead += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.myMark = this.myBytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.myMark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.myBytesRead = this.myMark;
    }

    public long getBytesRead() {
        return this.myBytesRead;
    }
}

