/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public final class ByteSequenceDataExternalizer
implements DataExternalizer<ByteArraySequence> {
    public static final ByteSequenceDataExternalizer INSTANCE = new ByteSequenceDataExternalizer();

    @Override
    public void save(@NotNull DataOutput out, ByteArraySequence value) throws IOException {
        out.write(value.getInternalBuffer(), value.getOffset(), value.getLength());
    }

    @Override
    public ByteArraySequence read(@NotNull DataInput in) throws IOException {
        byte[] buf = ArrayUtil.newByteArray(((InputStream)((Object)in)).available());
        in.readFully(buf);
        return ByteArraySequence.create(buf);
    }
}

