/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Unsafe;
import com.intellij.util.lang.JavaVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteBufferUtil {
    private static final MethodHandle invokeCleaner = ByteBufferUtil.findInvokeCleaner();
    private static final MethodHandle address = ByteBufferUtil.findAddress();
    private static final int byteArrayBaseOffset = ByteBufferUtil.byteArrayBaseOffset();

    @Nullable
    private static MethodHandle findInvokeCleaner() {
        MethodHandle invokeCleaner = null;
        try {
            if (JavaVersion.current().feature >= 9) {
                Object unsafe = ReflectionUtil.getUnsafe();
                MethodType type = MethodType.methodType(Void.TYPE, ByteBuffer.class);
                invokeCleaner = MethodHandles.publicLookup().findVirtual(unsafe.getClass(), "invokeCleaner", type).bindTo(unsafe);
            }
        }
        catch (Throwable t) {
            Logger.getInstance(ByteBufferUtil.class).warn(t);
        }
        return invokeCleaner;
    }

    @Nullable
    private static MethodHandle findAddress() {
        MethodHandle address = null;
        try {
            if (JavaVersion.current().feature >= 9) {
                Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                address = MethodHandles.lookup().findVirtual(directBufferClass, "address", MethodType.methodType(Long.TYPE));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    private static int byteArrayBaseOffset() {
        return Unsafe.arrayBaseOffset(byte[].class);
    }

    public static boolean cleanBuffer(@NotNull ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return true;
        }
        if (invokeCleaner != null) {
            try {
                invokeCleaner.invoke(buffer);
                return true;
            }
            catch (Throwable t) {
                ByteBufferUtil.getLogger().warn(t);
                return false;
            }
        }
        try {
            Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            Object cleaner = directBufferClass.getDeclaredMethod("cleaner", new Class[0]).invoke((Object)buffer, new Object[0]);
            if (cleaner != null) {
                cleanerClass.getDeclaredMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            ByteBufferUtil.getLogger().warn(e);
            return false;
        }
    }

    public static void copyMemory(@NotNull ByteBuffer src, int index, byte[] dst, int dstIndex, int length) {
        if (address != null) {
            try {
                long address = ByteBufferUtil.address.invoke(src);
                Unsafe.copyMemory(null, address + (long)index, dst, byteArrayBaseOffset + dstIndex, length);
                return;
            }
            catch (Throwable e) {
                ByteBufferUtil.getLogger().warn(e);
            }
        }
        ByteBuffer buf = src.duplicate();
        buf.position(index);
        buf.get(dst, dstIndex, length);
    }

    public static long getAddress(@NotNull ByteBuffer src) {
        try {
            return address.invoke(src);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(ByteBufferUtil.class);
    }
}

