/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.PersistentMap;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class IntMapForwardIndex
implements IntForwardIndex,
MeasurableIndexStore {
    @NotNull
    private final Path myStorageFile;
    private final boolean myHasChunks;
    @NotNull
    private volatile PersistentMap<Integer, Integer> myPersistentMap;

    public IntMapForwardIndex(@NotNull Path storageFile, boolean hasChunks) throws IOException {
        this.myStorageFile = storageFile;
        this.myHasChunks = hasChunks;
        this.myPersistentMap = IntMapForwardIndex.createMap(this.myStorageFile, this.myHasChunks);
    }

    @NotNull
    private static PersistentMap<Integer, Integer> createMap(@NotNull Path storageFile, boolean hasChunks) throws IOException {
        return PersistentMapBuilder.newBuilder(storageFile, EnumeratorIntegerDescriptor.INSTANCE, EnumeratorIntegerDescriptor.INSTANCE).inlineValues().hasChunks(hasChunks).build();
    }

    @Override
    public int getInt(int key) throws IOException {
        return (Integer)this.myPersistentMap.get(key);
    }

    @Override
    public void putInt(int key, int value) throws IOException {
        this.myPersistentMap.put(key, value);
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public int keysCountApproximately() {
        if (this.myPersistentMap instanceof MeasurableIndexStore) {
            return ((MeasurableIndexStore)((Object)this.myPersistentMap)).keysCountApproximately();
        }
        return -1;
    }

    @Override
    public void clear() throws IOException {
        this.myPersistentMap.closeAndClean();
        this.myPersistentMap = IntMapForwardIndex.createMap(this.myStorageFile, this.myHasChunks);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }
}

